<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-20 17:19:59
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Enterprise
 * @method addEnterpriseByParams(array $params) 添加企业
 * @method editEnterpriseByParams(array $params) 编辑企业
 * @method getEnterpriseListByParams(array $params) 企业列表
 * @method getEnterpriseListByPermissionByParams(array $params) 通过身份获取企业列表
 * @method getAllEnterpriseListByFilterByParams(array $params) 获取企业列表(分页)
 * @method transferEnterpriseByParams(array $params) 转移客户
 * @method getEnterpriseTransferLogByParams(array $params) 企业归属记录
 * @method deleteEnterpriseByParams(array $params) 删除企业
 * @method getEnterpriseByParams(array $params) 根据名称或者企业组id获取企业
 * @method getEnterpriseByNameByParams(array $params) 根据名称或者企业id获取企业
 * @method getEnterpriseInfoByParams(array $params) 根据企业id获取企业信息
 * @method checkEnterpriseOrderStatusByParams(array $params) 同步拍摄订单拍摄状态
 * @method getEnterpriseNameByQccByParams(array $params) 通过企查查获取企业信息
 * @method getEnterpriseByStaffIdByParams(array $params) 通过staffId获取七日未跟进的企业
 */
class Enterprise {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Enterprise";

    /**
     * 添加企业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addEnterprise () {
        return RpcClass::getClass(self::$serviceName, self::$className)->addEnterprise([]);
    }

    /**
     * 编辑企业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editEnterprise () {
        return RpcClass::getClass(self::$serviceName, self::$className)->editEnterprise([]);
    }

    /**
     * 企业列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getEnterpriseList (int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseList(["page" => $page, "page_size" => $page_size]);
    }

    /**
     * 通过身份获取企业列表
     * @return  mixed
    */
    public static function getEnterpriseListByPermission () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseListByPermission();
    }

    /**
     * 获取企业列表(分页)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAllEnterpriseListByFilter (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllEnterpriseListByFilter(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 转移客户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function transferEnterprise () {
        return RpcClass::getClass(self::$serviceName, self::$className)->transferEnterprise([]);
    }

    /**
     * 企业归属记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getEnterpriseTransferLog () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseTransferLog([]);
    }

    /**
     * 删除企业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function deleteEnterprise (int $enterprise_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteEnterprise(["enterprise_id" => $enterprise_id]);
    }

    /**
     * 根据名称或者企业组id获取企业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getEnterprise (string $enterprise_name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterprise(["enterprise_name" => $enterprise_name]);
    }

    /**
     * 根据名称或者企业id获取企业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getEnterpriseByName (string $enterprise_name = '', int $enterprise_id = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseByName(["enterprise_name" => $enterprise_name, "enterprise_id" => $enterprise_id]);
    }

    /**
     * 根据企业id获取企业信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getEnterpriseInfo (int $enterprise_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseInfo(["enterprise_id" => $enterprise_id]);
    }

    /**
     * 同步拍摄订单拍摄状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function checkEnterpriseOrderStatus (int $enterprise_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkEnterpriseOrderStatus(["enterprise_id" => $enterprise_id]);
    }

    /**
     * 通过企查查获取企业信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getEnterpriseNameByQcc (string $enterpriseName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseNameByQcc(["enterpriseName" => $enterpriseName]);
    }

    /**
     * 通过staffId获取七日未跟进的企业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getEnterpriseByStaffId (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseByStaffId(["staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}