<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-31 10:28:18
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Refund
 * @method canRefundMoneyByParams(array $params) 获取可退款金额
 * @method applyByParams(array $params) 申请退款
 * @method detailByParams(array $params) 退款详情
 * @method listByParams(array $params) 退款列表
 * @method financialPaidByParams(array $params) 财务已打款
 * @method financialRejectedByParams(array $params) 财务退款拒绝
 * @method paidSuccessByParams(array $params) 打款成功
 * @method paidFailByParams(array $params) 打款失败
 */
class Refund {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Refund";

    /**
     * 获取可退款金额
     * @return  mixed
    */
    public static function canRefundMoney (int $account_id, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canRefundMoney(["account_id" => $account_id, "type" => $type]);
    }
    /**
     * 申请退款
     * @return  mixed
    */
    public static function apply (int $account_id, float $money, string $type, string $account_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->apply(["account_id" => $account_id, "money" => $money, "type" => $type, "account_type" => $account_type]);
    }
    /**
     * 退款详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 退款列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 财务已打款
     * @return  bool
    */
    public static function financialPaid (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->financialPaid(["id" => $id]);
    }
    /**
     * 财务退款拒绝
     * @return  mixed
    */
    public static function financialRejected (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->financialRejected(["id" => $id]);
    }
    /**
     * 打款成功
     * @return  bool
    */
    public static function paidSuccess (int $id, string $voucherNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paidSuccess(["id" => $id, "voucherNo" => $voucherNo]);
    }
    /**
     * 打款失败
     * @return  mixed
    */
    public static function paidFail (int $id, string $failReason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paidFail(["id" => $id, "failReason" => $failReason]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}