<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-31 10:28:18
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Photo
 * @method getPhotoByParams(array $params) 获取券码订单拍摄照片
 * @method getShootOrderPhotoByParams(array $params) 获取拍摄订单拍摄照片
 * @method getOutShootPhotoByParams(array $params) 获取外拍订单拍摄照片
 */
class Photo {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Photo";

    /**
     * 获取券码订单拍摄照片
     * @return  mixed
    */
    public static function getPhoto (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhoto(["order_id" => $order_id]);
    }
    /**
     * 获取拍摄订单拍摄照片
     * @return  mixed
    */
    public static function getShootOrderPhoto (int $order_id, string $start, string $end) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShootOrderPhoto(["order_id" => $order_id, "start" => $start, "end" => $end]);
    }
    /**
     * 获取外拍订单拍摄照片
     * @return  mixed
    */
    public static function getOutShootPhoto (array $order_id_group) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOutShootPhoto(["order_id_group" => $order_id_group]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}