<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-31 10:28:18
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Invoice
 * @method applyInvoiceByParams(array $params) 申请开票
 * @method invoiceDetailByParams(array $params) 发票详情
 * @method deleteInvoiceByParams(array $params) 发票删除
 * @method invoiceListByParams(array $params) 开票记录
 * @method saleTaxNumListByParams(array $params) 获取销方
 */
class Invoice {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Invoice";

    /**
     * 申请开票
     * @return  bool
    */
    public static function applyInvoice (string $title, int $contractId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->applyInvoice(["title" => $title, "contractId" => $contractId]);
    }
    /**
     * 发票详情
     * @return  \Mainto\Bridge\Structs\Business\DTO\Invoice\InvoiceDetail\InvoiceDetailDTO
    */
    public static function invoiceDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->invoiceDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Invoice\InvoiceDetail\InvoiceDetailDTO"
        );
    }
    /**
     * 发票删除
     * @return  bool
    */
    public static function deleteInvoice (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteInvoice(["id" => $id]);
    }
    /**
     * 开票记录
     * @return  array
    */
    public static function invoiceList (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->invoiceList(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Invoice\InvoiceList\InvoiceListDTO[]"
        );
    }
    /**
     * 获取销方
     * @return  array
    */
    public static function saleTaxNumList (int $enterpriseId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->saleTaxNumList(["enterpriseId" => $enterpriseId]),
            "\Mainto\Bridge\Structs\Business\DTO\Invoice\SaleTaxNumList\SaleTaxNumListDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}