<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-29 19:12:32
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Account
 * @method createByParams(array $params) 创建资金账户
 * @method updateByParams(array $params) 编辑资金账户
 * @method listByParams(array $params) 资金账户列表
 * @method flowListByParams(array $params) 资金流水列表
 * @method detailByParams(array $params) 获取单个账户详情
 * @method recordingByParams(array $params) 工作台：录款
 * @method deductionByParams(array $params) 工作台：扣款
 * @method accountBackByShootOrderByParams(array $params) 工作台：拍摄订单退回
 * @method accountBackByOutShootOrderByParams(array $params) 工作台：外拍拍摄订单退回
 */
class Account {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Account";

    /**
     * 创建资金账户
     * @return  mixed
    */
    public static function create (int $enterprise_id, string $account_type, string $account_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["enterprise_id" => $enterprise_id, "account_type" => $account_type, "account_name" => $account_name]);
    }
    /**
     * 编辑资金账户
     * @return  bool
    */
    public static function update (int $account_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["account_id" => $account_id]);
    }
    /**
     * 资金账户列表
     * @return  mixed
    */
    public static function list (int $enterprise_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["enterprise_id" => $enterprise_id]);
    }
    /**
     * 资金流水列表
     * @return  mixed
    */
    public static function flowList (int $enterprise_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->flowList(["enterprise_id" => $enterprise_id]);
    }
    /**
     * 获取单个账户详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 工作台：录款
     * @return  bool
    */
    public static function recording () {
        return RpcClass::getClass(self::$serviceName, self::$className)->recording([]);
    }
    /**
     * 工作台：扣款
     * @return  bool
    */
    public static function deduction () {
        return RpcClass::getClass(self::$serviceName, self::$className)->deduction([]);
    }
    /**
     * 工作台：拍摄订单退回
     * @return  bool
    */
    public static function accountBackByShootOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->accountBackByShootOrder([]);
    }
    /**
     * 工作台：外拍拍摄订单退回
     * @return  bool
    */
    public static function accountBackByOutShootOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->accountBackByOutShootOrder([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}