<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-18 19:13:40
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Preferential
 */
class Preferential {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Preferential";

    /**
     * 导出券码列表
     * @return  mixed
    */
    public static function exportPreferentialList (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPreferentialList(["order_id" => $order_id]);
    }
    /**
     * 获取券码使用详情
     * @return  mixed
    */
    public static function getPreferentialUseInfo (array $search_info, int $order_id, string $white_list, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialUseInfo(["search_info" => $search_info, "order_id" => $order_id, "white_list" => $white_list, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 导出券码使用详情(部分)
     * @return  mixed
    */
    public static function exportPreferentialUseInfoPart (int $order_id, array $search_info = [], string $white_list = '', int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPreferentialUseInfoPart(["order_id" => $order_id, "search_info" => $search_info, "white_list" => $white_list, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 导出券码使用详情(全部)
     * @return  mixed
    */
    public static function exportPreferentialUseInfo (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPreferentialUseInfo(["order_id" => $order_id]);
    }
    /**
     * 获取礼品卡卡面列表(全部)
     * @return  mixed
    */
    public static function allGiftCardCover (int $topic_id, string $title, bool $has_topic_info = false, bool $is_on_sale) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allGiftCardCover(["topic_id" => $topic_id, "title" => $title, "has_topic_info" => $has_topic_info, "is_on_sale" => $is_on_sale]);
    }
    /**
     * 批量券码作废
     * @return  mixed
    */
    public static function batchAbolish (int $order_id, array $codes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAbolish(["order_id" => $order_id, "codes" => $codes]);
    }
    /**
     * 获取门店1030店铺实体礼品卡面信息
     * @return  array
    */
    public static function getGiftCardCoverByStoreId (int $storeId = 1030) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGiftCardCoverByStoreId(["storeId" => $storeId]);
    }
    /**
     * 获取门店1030店铺实体产品卡信息
     * @return  mixed
    */
    public static function getProductCardByStoreId (int $storeId = 1030) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardByStoreId(["storeId" => $storeId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}