<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-18 19:13:40
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Manager
 */
class Manager {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Manager";

    /**
     * 获取管理员列表
     * @return  \Mainto\Bridge\Structs\Business\DTO\Manager\ManagerList\ListDTO
    */
    public static function list (int $page = 1, int $pageSize = 15, string $staffName) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize, "staffName" => $staffName]),
            "\Mainto\Bridge\Structs\Business\DTO\Manager\ManagerList\ListDTO"
        );
    }
    /**
     * 创建管理员
     * @return  bool
    */
    public static function create (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["staffId" => $staffId]);
    }
    /**
     * 修改管理员启用状态
     * @return  bool
    */
    public static function enable (int $staffId, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enable(["staffId" => $staffId, "status" => $status]);
    }
    /**
     * 获取管理员
     * @return  \Mainto\Bridge\Structs\Business\DTO\Manager\Detail\DetailDTO
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Manager\Detail\DetailDTO"
        );
    }
    /**
     * 给管理员授权角色
     * @return  bool
    */
    public static function grantRole (int $id, array $roleIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantRole(["id" => $id, "roleIds" => $roleIds]);
    }
    /**
     * 给管理员授权权限
     * @return  bool
    */
    public static function grantPermissions (int $staffId, array $permissionIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantPermissions(["staffId" => $staffId, "permissionIds" => $permissionIds]);
    }
    /**
     * 通过伙伴姓名或花名获得可能的工号
     * @return  array
    */
    public static function searchStaff (string $staffName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStaff(["staffName" => $staffName]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}