<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-21 16:57:36
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Order";

    /**
     * 查询订单
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\OrderList\OrderListDTO
    */
    public static function orderList (string $orderStatus, string $paymentStatus, string $contractNo, string $orderNo, string $customerPhone, string $link, string $enterpriseName, int $enterpriseId, int $creatorId, int $page = 1, int $pageSize = 20, string $orderType, bool $isSpecialOrder = false, int $contractId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderList(["orderStatus" => $orderStatus, "paymentStatus" => $paymentStatus, "contractNo" => $contractNo, "orderNo" => $orderNo, "customerPhone" => $customerPhone, "link" => $link, "enterpriseName" => $enterpriseName, "enterpriseId" => $enterpriseId, "creatorId" => $creatorId, "page" => $page, "pageSize" => $pageSize, "orderType" => $orderType, "isSpecialOrder" => $isSpecialOrder, "contractId" => $contractId]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\OrderList\OrderListDTO"
        );
    }
    /**
     * 订单详情
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\OrderDetail\OrderDetailDTO
    */
    public static function orderDetail (int $orderId, int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderDetail(["orderId" => $orderId, "id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\OrderDetail\OrderDetailDTO"
        );
    }
    /**
     * 新增订单
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\CreateOrder\CreateOrderDTO
    */
    public static function createOrder (int $contractId, string $customerPhone, string $enterpriseName, string $link, int $contractArea, int $enterpriseId, string $customerType, string $orderType, string $brand, array $purchaseInfo, string $consumeMethod, int $whiteListId, string $remark, string $advanced = 'not', float $originPrice, float $realPay, float $discount, array $extend, bool $isSpecialOrder = false, int $isCustomizedPhysicalCard, int $deliveryCertificationType, string $deliveryCertificationValue) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createOrder(["contractId" => $contractId, "customerPhone" => $customerPhone, "enterpriseName" => $enterpriseName, "link" => $link, "contractArea" => $contractArea, "enterpriseId" => $enterpriseId, "customerType" => $customerType, "orderType" => $orderType, "brand" => $brand, "purchaseInfo" => $purchaseInfo, "consumeMethod" => $consumeMethod, "whiteListId" => $whiteListId, "remark" => $remark, "advanced" => $advanced, "originPrice" => $originPrice, "realPay" => $realPay, "discount" => $discount, "extend" => $extend, "isSpecialOrder" => $isSpecialOrder, "isCustomizedPhysicalCard" => $isCustomizedPhysicalCard, "deliveryCertificationType" => $deliveryCertificationType, "deliveryCertificationValue" => $deliveryCertificationValue]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\CreateOrder\CreateOrderDTO"
        );
    }
    /**
     * 确认支付
     * @return  bool
    */
    public static function payOrder (int $orderId, int $accountId, float $payOrderMoney, float $creditOrderMoney, bool $isSpecialOrder = false, string $orderType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->payOrder(["orderId" => $orderId, "accountId" => $accountId, "payOrderMoney" => $payOrderMoney, "creditOrderMoney" => $creditOrderMoney, "isSpecialOrder" => $isSpecialOrder, "orderType" => $orderType]);
    }
    /**
     * 删除订单
     * @return  bool
    */
    public static function deleteOrder (int $id, bool $isSpecialOrder = false, string $orderType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrder(["id" => $id, "isSpecialOrder" => $isSpecialOrder, "orderType" => $orderType]);
    }
    /**
     * 编辑订单
     * @return  bool
    */
    public static function editOrder (int $id, string $customerPhone, string $enterpriseName, string $link, int $contractArea, int $enterpriseId, string $customerType, string $orderType, string $brand, array $purchaseInfo, string $consumeMethod, int $whiteListId, string $remark, string $advanced = 'not', float $originPrice, float $realPay, float $discount, array $extend, bool $isSpecialOrder = false, int $isCustomizedPhysicalCard, int $deliveryCertificationType, string $deliveryCertificationValue) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editOrder(["id" => $id, "customerPhone" => $customerPhone, "enterpriseName" => $enterpriseName, "link" => $link, "contractArea" => $contractArea, "enterpriseId" => $enterpriseId, "customerType" => $customerType, "orderType" => $orderType, "brand" => $brand, "purchaseInfo" => $purchaseInfo, "consumeMethod" => $consumeMethod, "whiteListId" => $whiteListId, "remark" => $remark, "advanced" => $advanced, "originPrice" => $originPrice, "realPay" => $realPay, "discount" => $discount, "extend" => $extend, "isSpecialOrder" => $isSpecialOrder, "isCustomizedPhysicalCard" => $isCustomizedPhysicalCard, "deliveryCertificationType" => $deliveryCertificationType, "deliveryCertificationValue" => $deliveryCertificationValue]);
    }
    /**
     * 支付尾款
     * @return  mixed
    */
    public static function payOrderFinal (int $id, string $pay_at, string $pay_type, float $final_pay_money, array $evidence, string $fluent_num, array $change_info) {
        return RpcClass::getClass(self::$serviceName, self::$className)->payOrderFinal(["id" => $id, "pay_at" => $pay_at, "pay_type" => $pay_type, "final_pay_money" => $final_pay_money, "evidence" => $evidence, "fluent_num" => $fluent_num, "change_info" => $change_info]);
    }
    /**
     * 获取订单购买详情
     * @return  mixed
    */
    public static function getPurchaseInfo (int $orderId, bool $isSpecialOrder = false, string $orderType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseInfo(["orderId" => $orderId, "isSpecialOrder" => $isSpecialOrder, "orderType" => $orderType]);
    }
    /**
     * 券码订单中已提取券码状态数量
     * @return  array
    */
    public static function codeStatusCount (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->codeStatusCount(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\CodeStatusCount\CodeStatusCountDTO[]"
        );
    }
    /**
     * 取消订单
     * @return  bool
    */
    public static function cancel (int $id, string $reason, bool $isSpecialOrder = false, string $orderType, array $cancelItems) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id, "reason" => $reason, "isSpecialOrder" => $isSpecialOrder, "orderType" => $orderType, "cancelItems" => $cancelItems]);
    }
    /**
     * 根据创建记录作废券码
     * @return  bool
    */
    public static function abolishByLogId (int $id, string $type, int $createLogId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishByLogId(["id" => $id, "type" => $type, "createLogId" => $createLogId]);
    }
    /**
     * 外拍订单退/补差价
     * @return  bool
    */
    public static function outShootFinished (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->outShootFinished(["id" => $id]);
    }
    /**
     * 发送问卷调查表
     * @return  bool
    */
    public static function outShootSendQuestion (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->outShootSendQuestion(["id" => $id]);
    }
    /**
     * 获取关联拍摄订单列表
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\GetPhotoOrder\PhotoGetOrderDTO
    */
    public static function getPhotoOrder (int $groupOrderId, string $userPhone, string $userName, string $orderNo, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPhotoOrder(["groupOrderId" => $groupOrderId, "userPhone" => $userPhone, "userName" => $userName, "orderNo" => $orderNo, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\GetPhotoOrder\PhotoGetOrderDTO"
        );
    }
    /**
     * 修改拍摄门店
     * @return  bool
    */
    public static function batchUpdatePhotoOrderStore (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdatePhotoOrderStore(["data" => $data]);
    }
    /**
     * 获取门店驳回、取消订单列表
     * @return  array
    */
    public static function getRejectPhotoOrderListByOrderId (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRejectPhotoOrderListByOrderId(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\GetRejectPhotoOrderListByOrderId\RejectPhotoOrderListByOrderIdGetDTO[]"
        );
    }
    /**
     * 获取未提取海马体订单的团购单数量
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\UnextractGroupOrderCount\UnextractGroupOrderCountDTO
    */
    public static function unextractGroupOrderCount (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->unextractGroupOrderCount(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\UnextractGroupOrderCount\UnextractGroupOrderCountDTO"
        );
    }
    /**
     * 根据订单ID获取卡信息
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\GetOrderInfoById\OrderInfoByIdDTO
    */
    public static function getOrderInfoById (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderInfoById(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\GetOrderInfoById\OrderInfoByIdDTO"
        );
    }
    /**
     * 添加卡片申请
     * @return  int
    */
    public static function addCardApply (int $orderId, array $purchaseInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCardApply(["orderId" => $orderId, "purchaseInfo" => $purchaseInfo]);
    }
    /**
     * BD取消订单释放卡面
     * @return  bool
    */
    public static function cancelOrder (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder(["orderId" => $orderId]);
    }
    /**
     * BD确认收到货
     * @return  bool
    */
    public static function confirmOrder (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmOrder(["orderId" => $orderId]);
    }
    /**
     * 财务确认激活卡片
     * @return  bool
    */
    public static function addCardConfirm (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCardConfirm(["orderId" => $orderId]);
    }
    /**
     * 取消拍摄订单列表页展示
     * @return  array
    */
    public static function cancelShootOrderDetail (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->cancelShootOrderDetail(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\CancelShootOrderDetail\CancelShootOrderDetailDTO[]"
        );
    }
    /**
     * 根据券码创建批次ID获取订单号
     * @return  array
    */
    public static function getOrderCardLog (int $createLogId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderCardLog(["createLogId" => $createLogId]);
    }
    /**
     * 当订单是定制实体卡时取供应链提供的手机号
     * @return  mixed
    */
    public static function getDeliveryCertification () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDeliveryCertification();
    }
    /**
     * 海马体企业券码下载服务
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\DownloadPreferentialOrderDetail\OrderDetailDTO
    */
    public static function downloadPreferentialOrderDetail (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->downloadPreferentialOrderDetail(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\DownloadPreferentialOrderDetail\OrderDetailDTO"
        );
    }
    /**
     * 更换交付认证信息
     * @return  mixed
    */
    public static function changeDeliveryCertification (int $orderId, int $deliveryCertificationType, string $deliveryCertificationValue, array $deliveryCertificationVoucher) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeDeliveryCertification(["orderId" => $orderId, "deliveryCertificationType" => $deliveryCertificationType, "deliveryCertificationValue" => $deliveryCertificationValue, "deliveryCertificationVoucher" => $deliveryCertificationVoucher]);
    }
    /**
     * 发送交付认证联系方式短信
     * @return  bool
    */
    public static function sendDeliveryCertificationSms (string $deliveryCertificationValue, int $deliveryCertificationType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendDeliveryCertificationSms(["deliveryCertificationValue" => $deliveryCertificationValue, "deliveryCertificationType" => $deliveryCertificationType]);
    }
    /**
     * 验证发送交付认证短信
     * @return  bool
    */
    public static function checkDeliveryCertificationSms (string $deliveryCertificationValue, int $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkDeliveryCertificationSms(["deliveryCertificationValue" => $deliveryCertificationValue, "code" => $code]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}