<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-28 17:16:25
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Product";

    /**
     * 产品详情
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 计算产品卡价格
     * @return  mixed
    */
    public static function calProductCardPrice (array $limit) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calProductCardPrice(["limit" => $limit]);
    }
    /**
     * 所有门店分区
     * @return  mixed
    */
    public static function areaAll (string $module, string $type = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->areaAll(["module" => $module, "type" => $type]);
    }
    /**
     * 获取所有套餐
     * @return  mixed
    */
    public static function getAllPackage (array $modules, string $name, array $status, array $packageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllPackage(["modules" => $modules, "name" => $name, "status" => $status, "packageIds" => $packageIds]);
    }
    /**
     * 获取制定套餐区域价格
     * @return  float
    */
    public static function getSubPackageWithPriceAreas (array $subPackageIds, bool $calcPeopleNumMax, array $areaIds, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackageWithPriceAreas(["subPackageIds" => $subPackageIds, "calcPeopleNumMax" => $calcPeopleNumMax, "areaIds" => $areaIds, "storeIds" => $storeIds]);
    }
    /**
     * 子套餐可用门店列表
     * @return  array
    */
    public static function listStoreIdsBySubPackageIds (array $subPackageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listStoreIdsBySubPackageIds(["subPackageIds" => $subPackageIds]);
    }
    /**
     * 通过子套餐ids获取可售卖产品规则
     * @return  mixed
    */
    public static function listProductInfoBySubPackageIds (array $subPackageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listProductInfoBySubPackageIds(["subPackageIds" => $subPackageIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}