<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-05 15:52:19
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Refund
 */
class Refund {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Refund";

    /**
     * 获取可退款金额
     * @return  mixed
    */
    public static function canRefundMoney (int $account_id, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canRefundMoney(["account_id" => $account_id, "type" => $type]);
    }
    /**
     * 申请退款
     * @return  mixed
    */
    public static function apply (int $account_id, float $money, string $type, string $account_type, string $name, string $account, string $bank_name, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->apply(["account_id" => $account_id, "money" => $money, "type" => $type, "account_type" => $account_type, "name" => $name, "account" => $account, "bank_name" => $bank_name, "note" => $note]);
    }
    /**
     * 退款详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 退款列表
     * @return  mixed
    */
    public static function list (string $type, string $enterprise_name, string $status, int $account_id, int $input_staff_id, int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["type" => $type, "enterprise_name" => $enterprise_name, "status" => $status, "account_id" => $account_id, "input_staff_id" => $input_staff_id, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 财务已打款
     * @return  bool
    */
    public static function financialPaid (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->financialPaid(["id" => $id]);
    }
    /**
     * 财务退款拒绝
     * @return  mixed
    */
    public static function financialRejected (int $id, string $rejectedReason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->financialRejected(["id" => $id, "rejectedReason" => $rejectedReason]);
    }
    /**
     * 打款成功
     * @return  bool
    */
    public static function paidSuccess (int $id, string $voucherNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paidSuccess(["id" => $id, "voucherNo" => $voucherNo]);
    }
    /**
     * 打款失败
     * @return  mixed
    */
    public static function paidFail (int $id, string $failReason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paidFail(["id" => $id, "failReason" => $failReason]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}