<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-10 17:48:10
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Clue
 */
class Clue {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Clue";

    /**
     * 创建线索
     * @return  bool
    */
    public static function addClue (string $title, string $from, string $ipAddress, string $wxOpenid, string $contactName, string $contactGender, array $contactPostcard, string $contactPhone, int $photographArea, int $belongStaff, int $creatorId, string $remark, array $extend, string $scene) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addClue(["title" => $title, "from" => $from, "ipAddress" => $ipAddress, "wxOpenid" => $wxOpenid, "contactName" => $contactName, "contactGender" => $contactGender, "contactPostcard" => $contactPostcard, "contactPhone" => $contactPhone, "photographArea" => $photographArea, "belongStaff" => $belongStaff, "creatorId" => $creatorId, "remark" => $remark, "extend" => $extend, "scene" => $scene]);
    }
    /**
     * 创建线索（钉钉录入）
     * @return  bool
    */
    public static function addClueforAllCompany (string $title, string $from, string $contactName, string $contactGender, int $contactPhone, array $contactPostcard, int $photographArea, int $creatorId, string $remark, array $extend, int $belongStaff, string $scene = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->addClueforAllCompany(["title" => $title, "from" => $from, "contactName" => $contactName, "contactGender" => $contactGender, "contactPhone" => $contactPhone, "contactPostcard" => $contactPostcard, "photographArea" => $photographArea, "creatorId" => $creatorId, "remark" => $remark, "extend" => $extend, "belongStaff" => $belongStaff, "scene" => $scene]);
    }
    /**
     * 创建线索（待删除）
     * @return  bool
    */
    public static function createClue (string $title, string $from, string $ip_address, string $wx_openid, string $contact_name, string $contact_gender, array $contact_postcard, string $contact_phone, int $photograph_area, int $belong_staff, int $creator_id, string $remark, array $extend, string $scene = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->createClue(["title" => $title, "from" => $from, "ip_address" => $ip_address, "wx_openid" => $wx_openid, "contact_name" => $contact_name, "contact_gender" => $contact_gender, "contact_postcard" => $contact_postcard, "contact_phone" => $contact_phone, "photograph_area" => $photograph_area, "belong_staff" => $belong_staff, "creator_id" => $creator_id, "remark" => $remark, "extend" => $extend, "scene" => $scene]);
    }
    /**
     * 创建线索(门店)
     * @return  bool
    */
    public static function createStore (string $title, string $from, string $contactName, string $contactGender, array $contactPostcard, string $contactPhone, int $photographArea, int $belongStaff, int $creatorId, string $remark, array $extend, string $scene = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStore(["title" => $title, "from" => $from, "contactName" => $contactName, "contactGender" => $contactGender, "contactPostcard" => $contactPostcard, "contactPhone" => $contactPhone, "photographArea" => $photographArea, "belongStaff" => $belongStaff, "creatorId" => $creatorId, "remark" => $remark, "extend" => $extend, "scene" => $scene]);
    }
    /**
     * 编辑线索
     * @return  bool
    */
    public static function editClue (int $clueId, string $title, string $from, string $contactName, string $contactGender, string $contactPhone, int $photographArea, array $extend, string $scene = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->editClue(["clueId" => $clueId, "title" => $title, "from" => $from, "contactName" => $contactName, "contactGender" => $contactGender, "contactPhone" => $contactPhone, "photographArea" => $photographArea, "extend" => $extend, "scene" => $scene]);
    }
    /**
     * 线索详情
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\ClueDetail\ClueDetailDTO
    */
    public static function clueDetail (int $clueId, string $eventType) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueDetail(["clueId" => $clueId, "eventType" => $eventType]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueDetail\ClueDetailDTO"
        );
    }
    /**
     * 线索列表
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\ClueList\ClueListDTO
    */
    public static function clueList (int $page = 1, int $pageSize = 10, string $descSortColumn = 'log_at', string $title, string $contactName, string $contactPhone, string $from, bool $isInvalid = false, int $photographArea, int $belongStaff) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueList(["page" => $page, "pageSize" => $pageSize, "descSortColumn" => $descSortColumn, "title" => $title, "contactName" => $contactName, "contactPhone" => $contactPhone, "from" => $from, "isInvalid" => $isInvalid, "photographArea" => $photographArea, "belongStaff" => $belongStaff]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueList\ClueListDTO"
        );
    }
    /**
     * 线索列表（简易）
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\ClueSimpleList\ClueSimpleListDTO
    */
    public static function clueSimpleList (string $title, string $from, int $storeId, bool $isEnterprise, int $pageSize = 10, int $page = 1) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueSimpleList(["title" => $title, "from" => $from, "storeId" => $storeId, "isEnterprise" => $isEnterprise, "pageSize" => $pageSize, "page" => $page]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueSimpleList\ClueSimpleListDTO"
        );
    }
    /**
     * 门店端线索列表
     * @return  array
    */
    public static function clueListByWx (string $from, string $ipAddress, string $wxOpenid) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueListByWx(["from" => $from, "ipAddress" => $ipAddress, "wxOpenid" => $wxOpenid]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueListByWx\ClueListByWxDTO[]"
        );
    }
    /**
     * 线索列表
     * @return  array
    */
    public static function clueAll (string $descSortColumn = 'log_at', string $title, string $contactName, string $contactPhone, string $from, bool $isInvalid = false, int $photographArea, int $belongStaff) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueAll(["descSortColumn" => $descSortColumn, "title" => $title, "contactName" => $contactName, "contactPhone" => $contactPhone, "from" => $from, "isInvalid" => $isInvalid, "photographArea" => $photographArea, "belongStaff" => $belongStaff]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueAll\ClueAllDTO[]"
        );
    }
    /**
     * 放弃线索
     * @return  bool
    */
    public static function abandonClue (int $clueId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abandonClue(["clueId" => $clueId]);
    }
    /**
     * 领取线索
     * @return  bool
    */
    public static function receiveClue (int $clueId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveClue(["clueId" => $clueId]);
    }
    /**
     * 转移线索
     * @return  bool
    */
    public static function transferClue (int $clueId, int $receiveStaff, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->transferClue(["clueId" => $clueId, "receiveStaff" => $receiveStaff, "note" => $note]);
    }
    /**
     * 分配线索
     * @return  bool
    */
    public static function distributionClue (int $clueId, int $receiveStaff, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->distributionClue(["clueId" => $clueId, "receiveStaff" => $receiveStaff, "note" => $note]);
    }
    /**
     * 校验线索转企业
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\CheckTransferClueToEnterprise\CheckTransferClueToEnterpriseDTO
    */
    public static function checkTransferClueToEnterprise (int $clueId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->checkTransferClueToEnterprise(["clueId" => $clueId]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\CheckTransferClueToEnterprise\CheckTransferClueToEnterpriseDTO"
        );
    }
    /**
     * 转移线索成企业
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\TransferClueToEnterprise\TransferClueToEnterpriseDTO
    */
    public static function transferClueToEnterprise (int $clueId, string $enterpriseName, string $type, string $from, string $trade, string $area, string $socialCreditCode, string $note, array $extend, string $keyNo, string $startDate, string $operName, string $status, string $no, string $enterpriseLevel, string $contacts, string $contactNumber) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->transferClueToEnterprise(["clueId" => $clueId, "enterpriseName" => $enterpriseName, "type" => $type, "from" => $from, "trade" => $trade, "area" => $area, "socialCreditCode" => $socialCreditCode, "note" => $note, "extend" => $extend, "keyNo" => $keyNo, "startDate" => $startDate, "operName" => $operName, "status" => $status, "no" => $no, "enterpriseLevel" => $enterpriseLevel, "contacts" => $contacts, "contactNumber" => $contactNumber]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\TransferClueToEnterprise\TransferClueToEnterpriseDTO"
        );
    }
    /**
     * 线索转化率成交率统计
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\ClueRate\ClueRateDTO
    */
    public static function clueRate (int $month) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueRate(["month" => $month]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueRate\ClueRateDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}