<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-05 14:20:51
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PaymentRecord
 */
class PaymentRecord {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\PaymentRecord";

    /**
     * 录入追加付款/version3.0.0起不再支持追加付款
     * @return  mixed
    */
    public static function addAppendPayment (int $id, string $pay_at, float $pay_money, string $pay_type, array $evidence, string $pay_reason, string $fluent_num, string $remark) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addAppendPayment(["id" => $id, "pay_at" => $pay_at, "pay_money" => $pay_money, "pay_type" => $pay_type, "evidence" => $evidence, "pay_reason" => $pay_reason, "fluent_num" => $fluent_num, "remark" => $remark]);
    }
    /**
     * 编辑追加付款/version3.0.0起不再支持追加付款
     * @return  mixed
    */
    public static function editAppendPayment (int $id, string $pay_at, float $pay_money, string $pay_type, array $evidence, string $pay_reason, string $fluent_num, string $remark) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editAppendPayment(["id" => $id, "pay_at" => $pay_at, "pay_money" => $pay_money, "pay_type" => $pay_type, "evidence" => $evidence, "pay_reason" => $pay_reason, "fluent_num" => $fluent_num, "remark" => $remark]);
    }
    /**
     * 删除追加付款/version3.0.0起不再支持追加付款
     * @return  mixed
    */
    public static function deleteAppendPaymentRecord (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAppendPaymentRecord(["id" => $id]);
    }
    /**
     * 获取追加付款记录列表(仅限于单订单合同)
     * @return  mixed
    */
    public static function appendPaymentRecordList (int $id, int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->appendPaymentRecordList(["id" => $id, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 新增付款
     * @return  mixed
    */
    public static function createPaymentRecord (string $payment_type, array $evidence, string $pay_type, string $fluent_num, string $remark, int $account_id, float $pay_money, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPaymentRecord(["payment_type" => $payment_type, "evidence" => $evidence, "pay_type" => $pay_type, "fluent_num" => $fluent_num, "remark" => $remark, "account_id" => $account_id, "pay_money" => $pay_money, "extend" => $extend]);
    }
    /**
     * 通过bill服务的消息自动创建支付记录
     * @return  mixed
    */
    public static function autoCreatePaymentRecord (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoCreatePaymentRecord(["data" => $data]);
    }
    /**
     * 通过bill服务的消息自动添加支付凭证
     * @return  bool
    */
    public static function autoAddPaymentEvidence (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoAddPaymentEvidence(["data" => $data]);
    }
    /**
     * 新增远程收款
     * @return  mixed
    */
    public static function createPaymentUrl (int $account_id, float $pay_money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPaymentUrl(["account_id" => $account_id, "pay_money" => $pay_money]);
    }
    /**
     * 删除付款记录
     * @return  mixed
    */
    public static function deletePaymentRecord (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deletePaymentRecord(["id" => $id]);
    }
    /**
     * 获取付款记录列表
     * @return  mixed
    */
    public static function paymentRecordList (int $account_id, int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paymentRecordList(["account_id" => $account_id, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 查询付款信息
     * @return  array
    */
    public static function getBillInfoByFluentNum (string $fluentNum, string $payType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBillInfoByFluentNum(["fluentNum" => $fluentNum, "payType" => $payType]);
    }
    /**
     * 远程支付回调
     * @return  mixed
    */
    public static function payCallback (string $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->payCallback(["data" => $data]);
    }
    /**
     * 搜索收款记录
     * @return  array
    */
    public static function findPaymentRecord (int $paymentReId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findPaymentRecord(["paymentReId" => $paymentReId]);
    }
    /**
     * 工具台：收款转移资金账户
     * @return  bool
    */
    public static function transferFundAccount (int $enterpriseId, int $accountId, int $paymentReId, string $approvalNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->transferFundAccount(["enterpriseId" => $enterpriseId, "accountId" => $accountId, "paymentReId" => $paymentReId, "approvalNo" => $approvalNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}