<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-05 18:41:41
 */
namespace Mainto\Bridge\Invokes\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Common
 */
class Common {
    private static string $serviceName = "Business";

    private static string $className = "Common";

    /**
     * 获取又拍云签名
     * @return  mixed
    */
    public static function getUpyunSign () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpyunSign();
    }
    /**
     * 获取Host地址
     * @return  mixed
    */
    public static function getHost () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHost();
    }
    /**
     * getManagerInfo
     * @return  mixed
    */
    public static function getManagerInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getManagerInfo();
    }
    /**
     * 获取所有门店
     * @return  mixed
    */
    public static function getStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStore();
    }
    /**
     * 根据价格区id获取所有门店
     * @return  mixed
    */
    public static function getAllPriceArea (string $module, array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllPriceArea(["module" => $module, "ids" => $ids]);
    }
    /**
     * 根据产品id获取加修价格
     * @return  mixed
    */
    public static function getProductJxjyPrice (int $productId, int $peopleCount, array $storeLimit) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductJxjyPrice(["productId" => $productId, "peopleCount" => $peopleCount, "storeLimit" => $storeLimit]);
    }
    /**
     * 获取禁止售卖指定产品的门店列表
     * @return  mixed
    */
    public static function getBanStoreList (array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBanStoreList(["productIds" => $productIds]);
    }
    /**
     * 获取短链接
     * @return  mixed
    */
    public static function getShortUrl (string $url) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShortUrl(["url" => $url]);
    }
    /**
     * 发送券码订单通知
     * @return  mixed
    */
    public static function sendMsg (string $template, string $sendType, array $sendArr, array $sendContent) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendMsg(["template" => $template, "sendType" => $sendType, "sendArr" => $sendArr, "sendContent" => $sendContent]);
    }
    /**
     * 获取所有省份
     * @return  mixed
    */
    public static function getAllProvince () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProvince();
    }
    /**
     * 获取指定省份下的城市
     * @return  mixed
    */
    public static function getCity (int $province_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCity(["province_id" => $province_id]);
    }
    /**
     * 获取门店列表
     * @return  mixed
    */
    public static function getStoreList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreList();
    }
    /**
     * 获取门店所有产品
     * @return  mixed
    */
    public static function getProductsByStore (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsByStore(["store_id" => $store_id]);
    }
    /**
     * 获取门店所有产品（套餐）
     * @return  mixed
    */
    public static function getProductsByStoreWithPackage (int $storeId, string $status = 'on', int $showLevel = 2, bool $cHidden, bool $cHiddenRetail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsByStoreWithPackage(["storeId" => $storeId, "status" => $status, "showLevel" => $showLevel, "cHidden" => $cHidden, "cHiddenRetail" => $cHiddenRetail]);
    }
    /**
     * 获取子套餐详情
     * @return  mixed
    */
    public static function getSubPackageInfo (int $packageId, int $subPackageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackageInfo(["packageId" => $packageId, "subPackageId" => $subPackageId]);
    }
    /**
     * 获取产品详情
     * @return  mixed
    */
    public static function getProductDetail (int $store_id, int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductDetail(["store_id" => $store_id, "product_id" => $product_id]);
    }
    /**
     * 批量获取多个产品详情
     * @return  mixed
    */
    public static function getProductsBatchDetail (array $productIds, int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsBatchDetail(["productIds" => $productIds, "storeId" => $storeId]);
    }
    /**
     * 获取enum
     * @return  mixed
    */
    public static function getEnum (string $enum_name, string $field_name, string $type, string $prefix = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnum(["enum_name" => $enum_name, "field_name" => $field_name, "type" => $type, "prefix" => $prefix]);
    }
    /**
     * 根据MODULE获取类目/产品树
     * @return  mixed
    */
    public static function getProductTreeByModules (array $module, string $status = 'on', bool $c_hidden, int $show_level = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductTreeByModules(["module" => $module, "status" => $status, "c_hidden" => $c_hidden, "show_level" => $show_level]);
    }
    /**
     * 全部产品列表
     * @return  mixed
    */
    public static function getAllProduct (int $categoryId, string $module, string $status, bool $cHidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProduct(["categoryId" => $categoryId, "module" => $module, "status" => $status, "cHidden" => $cHidden]);
    }
    /**
     * 获取省市区三级
     * @return  mixed
    */
    public static function getAreaTree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreaTree();
    }
    /**
     * 通过伙伴姓名或花名获得可能的工号
     * @return  array
    */
    public static function searchStaff (string $staff_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStaff(["staff_name" => $staff_name]);
    }
    /**
     * 查询零售产品列表
     * @return  mixed
    */
    public static function getProductList (int $storeId, array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList(["storeId" => $storeId, "skuIds" => $skuIds]);
    }
    /**
     * 查询门店列表
     * @return  mixed
    */
    public static function getStoreByCity (array $storeType, bool $includeDelete, array $cityIds, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreByCity(["storeType" => $storeType, "includeDelete" => $includeDelete, "cityIds" => $cityIds, "type" => $type]);
    }
    /**
     * sign
     * @return  mixed
    */
    public static function sign (string $upyun_key) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sign(["upyun_key" => $upyun_key]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}