<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-31 17:03:41
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Role
 */
class Role {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Role";

    /**
     * 获取角色列表
     * @return  array
    */
    public static function list (string $title = '', int $page = 1, int $page_size = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["title" => $title, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取角色列表
     * @return  mixed
    */
    public static function all () {
        return RpcClass::getClass(self::$serviceName, self::$className)->all();
    }
    /**
     * 创建角色
     * @return  mixed
    */
    public static function create (string $title, array $permission_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["title" => $title, "permission_ids" => $permission_ids]);
    }
    /**
     * 角色信息
     * @return  mixed
    */
    public static function detail (int $role_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["role_id" => $role_id]);
    }
    /**
     * 设置角色权限
     * @return  bool
    */
    public static function update (int $role_id, array $permission_ids, string $title = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["role_id" => $role_id, "permission_ids" => $permission_ids, "title" => $title]);
    }
    /**
     * 删除角色
     * @return  mixed
    */
    public static function delete (int $role_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["role_id" => $role_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}