<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-07 14:59:44
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OutShoot
 */
class OutShoot {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\OutShoot";

    /**
     * 获取外摄订单详情
     * @return  array
    */
    public static function detail (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["order_no" => $order_no]);
    }
    /**
     * 添加外拍队员
     * @return  bool
    */
    public static function addTeamMember (string $order_no, int $staff_id, string $team_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addTeamMember(["order_no" => $order_no, "staff_id" => $staff_id, "team_type" => $team_type]);
    }
    /**
     * 删除外拍队员
     * @return  bool
    */
    public static function deleteTeamMember (string $order_no, int $staff_id, string $team_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteTeamMember(["order_no" => $order_no, "staff_id" => $staff_id, "team_type" => $team_type]);
    }
    /**
     * 获取业绩填写详情
     * @return  array
    */
    public static function performanceDetail (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->performanceDetail(["order_no" => $order_no]);
    }
    /**
     * 编辑实际拍摄内容
     * @return  bool
    */
    public static function editShootContent (string $order_no, array $final_purchase_info, float $origin_price, float $real_money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editShootContent(["order_no" => $order_no, "final_purchase_info" => $final_purchase_info, "origin_price" => $origin_price, "real_money" => $real_money]);
    }
    /**
     * 编辑伙伴业绩盘点
     * @return  bool
    */
    public static function editMemberPerformance (string $order_no, array $member_performance) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editMemberPerformance(["order_no" => $order_no, "member_performance" => $member_performance]);
    }
    /**
     * 编辑门店业绩盘点
     * @return  bool
    */
    public static function editStorePerformance (string $order_no, array $store_performance) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStorePerformance(["order_no" => $order_no, "store_performance" => $store_performance]);
    }
    /**
     * 业绩确认
     * @return  mixed
    */
    public static function confirmPerformance (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmPerformance(["order_no" => $order_no]);
    }
    /**
     * 工具箱：订单查询
     * @return  \Mainto\Bridge\Structs\Business\DTO\OutShoot\GetOrderInfoByOrderNo\OrderInfoGetByOrderNoDTO
    */
    public static function getOrderInfoByOrderNo (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderInfoByOrderNo(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\Business\DTO\OutShoot\GetOrderInfoByOrderNo\OrderInfoGetByOrderNoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}