<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-30 18:57:49
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Account
 */
class Account {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Account";

    /**
     * 创建资金账户
     * @return  mixed
    */
    public static function create (int $enterprise_id, string $account_type, string $account_name, string $social_credit_code = null, string $key_no = '', string $start_date = '', string $oper_name = '', string $status = '', string $no = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["enterprise_id" => $enterprise_id, "account_type" => $account_type, "account_name" => $account_name, "social_credit_code" => $social_credit_code, "key_no" => $key_no, "start_date" => $start_date, "oper_name" => $oper_name, "status" => $status, "no" => $no]);
    }
    /**
     * 编辑资金账户
     * @return  bool
    */
    public static function update (int $account_id, string $account_type, string $account_name, string $social_credit_code, string $key_no, string $start_date, string $oper_name, string $status, string $no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["account_id" => $account_id, "account_type" => $account_type, "account_name" => $account_name, "social_credit_code" => $social_credit_code, "key_no" => $key_no, "start_date" => $start_date, "oper_name" => $oper_name, "status" => $status, "no" => $no]);
    }
    /**
     * 资金账户列表
     * @return  mixed
    */
    public static function list (int $enterprise_id, int $page = 1, int $page_size = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["enterprise_id" => $enterprise_id, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 资金流水列表
     * @return  mixed
    */
    public static function flowList (int $enterprise_id, int $page = 1, int $page_size = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->flowList(["enterprise_id" => $enterprise_id, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取单个账户详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 工作台：录款
     * @return  bool
    */
    public static function recording (int $enterpriseId, int $accountId, float $money, string $recordingType, int $payAt, string $approvalNo, array $evidence) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recording(["enterpriseId" => $enterpriseId, "accountId" => $accountId, "money" => $money, "recordingType" => $recordingType, "payAt" => $payAt, "approvalNo" => $approvalNo, "evidence" => $evidence]);
    }
    /**
     * 工作台：扣款
     * @return  bool
    */
    public static function deduction (int $enterpriseId, int $accountId, float $money, string $deductionType, string $approvalNo, string $remark) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deduction(["enterpriseId" => $enterpriseId, "accountId" => $accountId, "money" => $money, "deductionType" => $deductionType, "approvalNo" => $approvalNo, "remark" => $remark]);
    }
    /**
     * 工作台：拍摄订单退回
     * @return  bool
    */
    public static function accountBackByShootOrder (string $orderNo, string $backType, float $money, string $approvalNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->accountBackByShootOrder(["orderNo" => $orderNo, "backType" => $backType, "money" => $money, "approvalNo" => $approvalNo]);
    }
    /**
     * 工作台：外拍拍摄订单退回
     * @return  bool
    */
    public static function accountBackByOutShootOrder (string $orderNo, string $backType, string $approvalNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->accountBackByOutShootOrder(["orderNo" => $orderNo, "backType" => $backType, "approvalNo" => $approvalNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}