<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-29 18:58:22
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class WhiteList
 */
class WhiteList {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\WhiteList";

    /**
     * 创建白名单
     * @return  \Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListCreateDTO
    */
    public static function create (array $whiteListTable, string $type) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create(["whiteListTable" => $whiteListTable, "type" => $type]),
            "\Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListCreateDTO"
        );
    }
    /**
     * 新增白名单
     * @return  \Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListAddDTO
    */
    public static function add (array $whiteListTable, int $whiteListId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->add(["whiteListTable" => $whiteListTable, "whiteListId" => $whiteListId]),
            "\Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListAddDTO"
        );
    }
    /**
     * 删除白名单指定内容
     * @return  int
    */
    public static function delete (array $contentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["contentIds" => $contentIds]);
    }
    /**
     * 获取白名单详情
     * @return  \Mainto\Bridge\Structs\Business\DTO\WhiteList\DetailDTO
    */
    public static function detail (int $orderId, int $page = 1, int $pageSize = 20, string $whiteList = '', bool $withSendInfo = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderId" => $orderId, "page" => $page, "pageSize" => $pageSize, "whiteList" => $whiteList, "withSendInfo" => $withSendInfo]),
            "\Mainto\Bridge\Structs\Business\DTO\WhiteList\DetailDTO"
        );
    }
    /**
     * 发送通知
     * @return  bool
    */
    public static function sendMsg (int $orderId, string $url) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendMsg(["orderId" => $orderId, "url" => $url]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}