<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-07 15:22:00
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Enterprise
 */
class Enterprise {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Enterprise";

    /**
     * 添加企业
     * @return  mixed
    */
    public static function addEnterprise (string $enterprise_name, string $type, string $title, string $tax_num, string $enterprise_address, string $bank, string $bank_account, string $from, string $trade, string $area, string $social_credit_code, string $note, array $extend, string $key_no, string $start_date, string $oper_name, string $status, string $no, string $enterprise_level, string $contacts, string $contact_number) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addEnterprise(["enterprise_name" => $enterprise_name, "type" => $type, "title" => $title, "tax_num" => $tax_num, "enterprise_address" => $enterprise_address, "bank" => $bank, "bank_account" => $bank_account, "from" => $from, "trade" => $trade, "area" => $area, "social_credit_code" => $social_credit_code, "note" => $note, "extend" => $extend, "key_no" => $key_no, "start_date" => $start_date, "oper_name" => $oper_name, "status" => $status, "no" => $no, "enterprise_level" => $enterprise_level, "contacts" => $contacts, "contact_number" => $contact_number]);
    }
    /**
     * 编辑企业
     * @return  bool
    */
    public static function editEnterprise (int $enterprise_id, string $enterprise_name, string $type, string $title, string $tax_num, string $enterprise_address, string $bank, string $bank_account, string $from, string $trade, string $area, string $social_credit_code, string $note, string $key_no, string $start_date, string $oper_name, string $status, string $no, string $enterprise_level, string $contacts, string $contact_number) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editEnterprise(["enterprise_id" => $enterprise_id, "enterprise_name" => $enterprise_name, "type" => $type, "title" => $title, "tax_num" => $tax_num, "enterprise_address" => $enterprise_address, "bank" => $bank, "bank_account" => $bank_account, "from" => $from, "trade" => $trade, "area" => $area, "social_credit_code" => $social_credit_code, "note" => $note, "key_no" => $key_no, "start_date" => $start_date, "oper_name" => $oper_name, "status" => $status, "no" => $no, "enterprise_level" => $enterprise_level, "contacts" => $contacts, "contact_number" => $contact_number]);
    }
    /**
     * 企业列表
     * @return  array
    */
    public static function getEnterpriseList (string $enterprise_name, int $belong_staff_id, string $from, int $page = 1, int $page_size = 10, string $enterprise_level) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseList(["enterprise_name" => $enterprise_name, "belong_staff_id" => $belong_staff_id, "from" => $from, "page" => $page, "page_size" => $page_size, "enterprise_level" => $enterprise_level]);
    }
    /**
     * 通过身份获取企业列表
     * @return  mixed
    */
    public static function getEnterpriseListByPermission () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseListByPermission();
    }
    /**
     * 获取企业列表(分页)
     * @return  mixed
    */
    public static function getAllEnterpriseListByFilter (string $enterpriseName, int $belongStaff, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllEnterpriseListByFilter(["enterpriseName" => $enterpriseName, "belongStaff" => $belongStaff, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 转移客户
     * @return  bool
    */
    public static function transferEnterprise (array $enterprise_ids, int $receive_staff, bool $all_transfer, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->transferEnterprise(["enterprise_ids" => $enterprise_ids, "receive_staff" => $receive_staff, "all_transfer" => $all_transfer, "note" => $note]);
    }
    /**
     * 企业归属记录
     * @return  array
    */
    public static function getEnterpriseTransferLog (int $enterprise_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseTransferLog(["enterprise_id" => $enterprise_id]);
    }
    /**
     * 删除企业
     * @return  int
    */
    public static function deleteEnterprise (int $enterprise_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteEnterprise(["enterprise_id" => $enterprise_id]);
    }
    /**
     * 根据名称或者企业组id获取企业
     * @return  array
    */
    public static function getEnterprise (string $enterprise_name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterprise(["enterprise_name" => $enterprise_name]);
    }
    /**
     * 根据名称或者企业id获取企业
     * @return  array
    */
    public static function getEnterpriseByName (string $enterprise_name = '', int $enterprise_id = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseByName(["enterprise_name" => $enterprise_name, "enterprise_id" => $enterprise_id]);
    }
    /**
     * 根据企业id获取企业信息
     * @return  array
    */
    public static function getEnterpriseInfo (int $enterprise_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseInfo(["enterprise_id" => $enterprise_id]);
    }
    /**
     * 同步拍摄订单拍摄状态
     * @return  mixed
    */
    public static function checkEnterpriseOrderStatus (int $enterprise_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkEnterpriseOrderStatus(["enterprise_id" => $enterprise_id]);
    }
    /**
     * 通过企查查获取企业信息
     * @return  array
    */
    public static function getEnterpriseNameByQcc (string $enterpriseName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseNameByQcc(["enterpriseName" => $enterpriseName]);
    }
    /**
     * 通过staffId获取七日未跟进的企业
     * @return  array
    */
    public static function getEnterpriseByStaffId (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnterpriseByStaffId(["staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}