<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-14 18:53:26
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class WorkStation
 */
class WorkStation {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\WorkStation";

    /**
     * 头部信息
     * @return  mixed
    */
    public static function workStationIndex (int $departmentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->workStationIndex(["departmentId" => $departmentId]);
    }
    /**
     * 首页折线数据
     * @return  \Mainto\Bridge\Structs\Business\DTO\WorkStation\PolylineDTO
    */
    public static function polylineData () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->polylineData(),
            "\Mainto\Bridge\Structs\Business\DTO\WorkStation\PolylineDTO"
        );
    }
    /**
     * 首页折线经理/主管数据数据
     * @return  array
    */
    public static function polylineDataManager () {
        return RpcClass::getClass(self::$serviceName, self::$className)->polylineDataManager();
    }
    /**
     * 资金状况经理/普通BD
     * @return  \Mainto\Bridge\Structs\Business\DTO\WorkStation\GetPaymentInfoDTO
    */
    public static function getPaymentInfo (int $departmentId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPaymentInfo(["departmentId" => $departmentId]),
            "\Mainto\Bridge\Structs\Business\DTO\WorkStation\GetPaymentInfoDTO"
        );
    }
    /**
     * 缓冲中获取工作台排名
     * @return  mixed
    */
    public static function getCurrentMonthRank () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCurrentMonthRank();
    }
    /**
     * 缓冲中获取工作台登陆人排名信息
     * @return  \Mainto\Bridge\Structs\Business\DTO\WorkStation\GetStaffRankInfoDTO
    */
    public static function getStaffRankInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffRankInfo(),
            "\Mainto\Bridge\Structs\Business\DTO\WorkStation\GetStaffRankInfoDTO"
        );
    }
    /**
     * 删除指定缓存接口
     * @return  bool
    */
    public static function deleteMultiple (array $keys) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteMultiple(["keys" => $keys]);
    }
    /**
     * 部门分组
     * @return  array
    */
    public static function getDepartmentTree () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentTree(),
            "\Mainto\Bridge\Structs\Business\DTO\WorkStation\GetDepartmentTreeDataDTO[]"
        );
    }
    /**
     * 线索转换
     * @return  array
    */
    public static function clueConversion (int $departmentId, string $limitMonth, string $from) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueConversion(["departmentId" => $departmentId, "limitMonth" => $limitMonth, "from" => $from]),
            "\Mainto\Bridge\Structs\Business\DTO\WorkStation\ClueConversionDTO[]"
        );
    }
    /**
     * 订单构成
     * @return  \Mainto\Bridge\Structs\Business\DTO\WorkStation\OrderConstituteDTO
    */
    public static function orderConstitute (int $departmentId, string $limitMonth) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderConstitute(["departmentId" => $departmentId, "limitMonth" => $limitMonth]),
            "\Mainto\Bridge\Structs\Business\DTO\WorkStation\OrderConstituteDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}