<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-18 15:48:36
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method orderListByParams(array $params) 查询订单
 * @method orderDetailByParams(array $params) 订单详情
 * @method createOrderByParams(array $params) 新增订单
 * @method payOrderByParams(array $params) 确认支付
 * @method deleteOrderByParams(array $params) 删除订单
 * @method editOrderByParams(array $params) 编辑订单
 * @method payOrderFinalByParams(array $params) 支付尾款
 * @method getPurchaseInfoByParams(array $params) 获取订单购买详情
 * @method codeStatusCountByParams(array $params) 券码订单中已提取券码状态数量
 * @method cancelByParams(array $params) 取消订单
 * @method abolishByLogIdByParams(array $params) 根据创建记录作废券码
 * @method outShootFinishedByParams(array $params) 外拍订单退/补差价
 * @method outShootSendQuestionByParams(array $params) 发送问卷调查表
 * @method getPhotoOrderByParams(array $params) 获取关联拍摄订单列表
 * @method batchUpdatePhotoOrderStoreByParams(array $params) 修改拍摄门店
 * @method getRejectPhotoOrderListByOrderIdByParams(array $params) 获取门店驳回、取消订单列表
 * @method unextractGroupOrderCountByParams(array $params) 获取未提取海马体订单的团购单数量
 * @method getOrderInfoByIdByParams(array $params) 根据订单ID获取卡信息
 * @method addCardApplyByParams(array $params) 添加卡片申请
 * @method cancelOrderByParams(array $params) BD取消订单释放卡面
 * @method confirmOrderByParams(array $params) BD确认收到货
 * @method addCardConfirmByParams(array $params) 财务确认激活卡片
 * @method cancelShootOrderDetailByParams(array $params) 取消拍摄订单列表页展示
 * @method getOrderCardLogByParams(array $params) 根据券码创建批次ID获取订单号
 * @method getDeliveryCertificationByParams(array $params) 当订单是定制实体卡时取供应链提供的手机号
 * @method downloadPreferentialOrderDetailByParams(array $params) 海马体企业券码下载服务
 * @method changeDeliveryCertificationByParams(array $params) 更换交付认证信息
 * @method sendDeliveryCertificationSmsByParams(array $params) 发送交付认证联系方式短信
 * @method checkDeliveryCertificationSmsByParams(array $params) 验证发送交付认证短信
 */
class Order {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Order";

    /**
     * 查询订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\OrderList\OrderListDTO
    */
    public static function orderList (int $page = 1, int $pageSize = 20, string $orderType, bool $isSpecialOrder = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderList(["page" => $page, "pageSize" => $pageSize, "orderType" => $orderType, "isSpecialOrder" => $isSpecialOrder]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\OrderList\OrderListDTO"
        );
    }

    /**
     * 订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\OrderDetail\OrderDetailDTO
    */
    public static function orderDetail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderDetail([]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\OrderDetail\OrderDetailDTO"
        );
    }

    /**
     * 新增订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\CreateOrder\CreateOrderDTO
    */
    public static function createOrder (string $advanced = 'not', float $originPrice, float $realPay, bool $isSpecialOrder = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createOrder(["advanced" => $advanced, "originPrice" => $originPrice, "realPay" => $realPay, "isSpecialOrder" => $isSpecialOrder]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\CreateOrder\CreateOrderDTO"
        );
    }

    /**
     * 确认支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function payOrder (int $orderId, int $accountId, float $payOrderMoney, float $creditOrderMoney, bool $isSpecialOrder = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->payOrder(["orderId" => $orderId, "accountId" => $accountId, "payOrderMoney" => $payOrderMoney, "creditOrderMoney" => $creditOrderMoney, "isSpecialOrder" => $isSpecialOrder]);
    }

    /**
     * 删除订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteOrder (int $id, bool $isSpecialOrder = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrder(["id" => $id, "isSpecialOrder" => $isSpecialOrder]);
    }

    /**
     * 编辑订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editOrder (int $id, string $advanced = 'not', float $originPrice, float $realPay, bool $isSpecialOrder = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editOrder(["id" => $id, "advanced" => $advanced, "originPrice" => $originPrice, "realPay" => $realPay, "isSpecialOrder" => $isSpecialOrder]);
    }

    /**
     * 支付尾款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function payOrderFinal (int $id, string $pay_type, float $final_pay_money, array $evidence) {
        return RpcClass::getClass(self::$serviceName, self::$className)->payOrderFinal(["id" => $id, "pay_type" => $pay_type, "final_pay_money" => $final_pay_money, "evidence" => $evidence]);
    }

    /**
     * 获取订单购买详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPurchaseInfo (int $orderId, bool $isSpecialOrder = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseInfo(["orderId" => $orderId, "isSpecialOrder" => $isSpecialOrder]);
    }

    /**
     * 券码订单中已提取券码状态数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function codeStatusCount (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->codeStatusCount(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\CodeStatusCount\CodeStatusCountDTO[]"
        );
    }

    /**
     * 取消订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancel (int $id, bool $isSpecialOrder = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id, "isSpecialOrder" => $isSpecialOrder]);
    }

    /**
     * 根据创建记录作废券码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function abolishByLogId (int $id, string $type, int $createLogId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishByLogId(["id" => $id, "type" => $type, "createLogId" => $createLogId]);
    }

    /**
     * 外拍订单退/补差价
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function outShootFinished (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->outShootFinished(["id" => $id]);
    }

    /**
     * 发送问卷调查表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function outShootSendQuestion (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->outShootSendQuestion(["id" => $id]);
    }

    /**
     * 获取关联拍摄订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\GetPhotoOrder\PhotoGetOrderDTO
    */
    public static function getPhotoOrder (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPhotoOrder(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\GetPhotoOrder\PhotoGetOrderDTO"
        );
    }

    /**
     * 修改拍摄门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchUpdatePhotoOrderStore (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdatePhotoOrderStore(["data" => $data]);
    }

    /**
     * 获取门店驳回、取消订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getRejectPhotoOrderListByOrderId (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRejectPhotoOrderListByOrderId(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\GetRejectPhotoOrderListByOrderId\RejectPhotoOrderListByOrderIdGetDTO[]"
        );
    }

    /**
     * 获取未提取海马体订单的团购单数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\UnextractGroupOrderCount\UnextractGroupOrderCountDTO
    */
    public static function unextractGroupOrderCount (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->unextractGroupOrderCount(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\UnextractGroupOrderCount\UnextractGroupOrderCountDTO"
        );
    }

    /**
     * 根据订单ID获取卡信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\GetOrderInfoById\OrderInfoByIdDTO
    */
    public static function getOrderInfoById (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderInfoById(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\GetOrderInfoById\OrderInfoByIdDTO"
        );
    }

    /**
     * 添加卡片申请
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function addCardApply (int $orderId, array $purchaseInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCardApply(["orderId" => $orderId, "purchaseInfo" => $purchaseInfo]);
    }

    /**
     * BD取消订单释放卡面
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancelOrder (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder(["orderId" => $orderId]);
    }

    /**
     * BD确认收到货
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function confirmOrder (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmOrder(["orderId" => $orderId]);
    }

    /**
     * 财务确认激活卡片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function addCardConfirm (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCardConfirm(["orderId" => $orderId]);
    }

    /**
     * 取消拍摄订单列表页展示
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function cancelShootOrderDetail (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->cancelShootOrderDetail(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\CancelShootOrderDetail\CancelShootOrderDetailDTO[]"
        );
    }

    /**
     * 根据券码创建批次ID获取订单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderCardLog (int $createLogId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderCardLog(["createLogId" => $createLogId]);
    }

    /**
     * 当订单是定制实体卡时取供应链提供的手机号
     * @return  mixed
    */
    public static function getDeliveryCertification () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDeliveryCertification();
    }

    /**
     * 海马体企业券码下载服务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\DownloadPreferentialOrderDetail\OrderDetailDTO
    */
    public static function downloadPreferentialOrderDetail (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->downloadPreferentialOrderDetail(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\DownloadPreferentialOrderDetail\OrderDetailDTO"
        );
    }

    /**
     * 更换交付认证信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function changeDeliveryCertification (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeDeliveryCertification(["orderId" => $orderId]);
    }

    /**
     * 发送交付认证联系方式短信
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendDeliveryCertificationSms (string $deliveryCertificationValue, int $deliveryCertificationType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendDeliveryCertificationSms(["deliveryCertificationValue" => $deliveryCertificationValue, "deliveryCertificationType" => $deliveryCertificationType]);
    }

    /**
     * 验证发送交付认证短信
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkDeliveryCertificationSms (string $deliveryCertificationValue, int $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkDeliveryCertificationSms(["deliveryCertificationValue" => $deliveryCertificationValue, "code" => $code]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}