<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-26 10:54:34
 */
namespace Mainto\Bridge\Invokes\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Common
 * @method getUpyunSignByParams(array $params) 获取又拍云签名
 * @method getHostByParams(array $params) 获取Host地址
 * @method getManagerInfoByParams(array $params) 获取管理员信息
 * @method getStoreByParams(array $params) 获取所有门店
 * @method getAllPriceAreaByParams(array $params) 根据价格区id获取所有门店
 * @method getProductJxjyPriceByParams(array $params) 根据产品id获取加修价格
 * @method getBanStoreListByParams(array $params) 获取禁止售卖指定产品的门店列表
 * @method getShortUrlByParams(array $params) 获取短链接
 * @method sendMsgByParams(array $params) 发送券码订单通知
 * @method getAllProvinceByParams(array $params) 获取所有省份
 * @method getCityByParams(array $params) 获取指定省份下的城市
 * @method getStoreListByParams(array $params) 获取门店列表
 * @method getProductsByStoreByParams(array $params) 获取门店所有产品
 * @method getProductsByStoreWithPackageByParams(array $params) 获取门店所有产品（套餐）
 * @method getSubPackageInfoByParams(array $params) 获取子套餐详情
 * @method getProductDetailByParams(array $params) 获取产品详情
 * @method getProductsBatchDetailByParams(array $params) 批量获取多个产品详情
 * @method getEnumByParams(array $params) 获取enum
 * @method getProductTreeByModulesByParams(array $params) 根据MODULE获取类目/产品树
 * @method getAllProductByParams(array $params) 全部产品列表
 * @method getAreaTreeByParams(array $params) 获取省市区三级
 * @method searchStaffByParams(array $params) 通过伙伴姓名或花名获得可能的工号
 * @method getProductListByParams(array $params) 查询零售产品列表
 * @method getStoreByCityByParams(array $params) 查询门店列表
 * @method signByParams(array $params) sign
 * @method bdStaffListByParams(array $params) BD组员工列表
 */
class Common {
    private static string $serviceName = "Business";

    private static string $className = "Common";

    /**
     * 获取又拍云签名
     * @return  mixed
    */
    public static function getUpyunSign () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpyunSign();
    }

    /**
     * 获取Host地址
     * @return  mixed
    */
    public static function getHost () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHost();
    }

    /**
     * 获取管理员信息
     * @return  mixed
    */
    public static function getManagerInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getManagerInfo();
    }

    /**
     * 获取所有门店
     * @return  mixed
    */
    public static function getStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStore();
    }

    /**
     * 根据价格区id获取所有门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAllPriceArea () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllPriceArea([]);
    }

    /**
     * 根据产品id获取加修价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductJxjyPrice (int $productId, int $peopleCount, array $storeLimit) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductJxjyPrice(["productId" => $productId, "peopleCount" => $peopleCount, "storeLimit" => $storeLimit]);
    }

    /**
     * 获取禁止售卖指定产品的门店列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getBanStoreList (array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBanStoreList(["productIds" => $productIds]);
    }

    /**
     * 获取短链接
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getShortUrl (string $url) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShortUrl(["url" => $url]);
    }

    /**
     * 发送券码订单通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function sendMsg (string $template, string $sendType, array $sendArr, array $sendContent) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendMsg(["template" => $template, "sendType" => $sendType, "sendArr" => $sendArr, "sendContent" => $sendContent]);
    }

    /**
     * 获取所有省份
     * @return  mixed
    */
    public static function getAllProvince () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProvince();
    }

    /**
     * 获取指定省份下的城市
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getCity (int $province_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCity(["province_id" => $province_id]);
    }

    /**
     * 获取门店列表
     * @return  mixed
    */
    public static function getStoreList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreList();
    }

    /**
     * 获取门店所有产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsByStore (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsByStore(["store_id" => $store_id]);
    }

    /**
     * 获取门店所有产品（套餐）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsByStoreWithPackage (int $storeId, string $status = 'on', int $showLevel = 2) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsByStoreWithPackage(["storeId" => $storeId, "status" => $status, "showLevel" => $showLevel]);
    }

    /**
     * 获取子套餐详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSubPackageInfo (int $packageId, int $subPackageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackageInfo(["packageId" => $packageId, "subPackageId" => $subPackageId]);
    }

    /**
     * 获取产品详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductDetail (int $store_id, int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductDetail(["store_id" => $store_id, "product_id" => $product_id]);
    }

    /**
     * 批量获取多个产品详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsBatchDetail (array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsBatchDetail(["productIds" => $productIds]);
    }

    /**
     * 获取enum
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getEnum (string $enum_name, string $field_name, string $type, string $prefix = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEnum(["enum_name" => $enum_name, "field_name" => $field_name, "type" => $type, "prefix" => $prefix]);
    }

    /**
     * 根据MODULE获取类目/产品树
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductTreeByModules (string $status = 'on', int $show_level = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductTreeByModules(["status" => $status, "show_level" => $show_level]);
    }

    /**
     * 全部产品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAllProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProduct([]);
    }

    /**
     * 获取省市区三级
     * @return  mixed
    */
    public static function getAreaTree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreaTree();
    }

    /**
     * 通过伙伴姓名或花名获得可能的工号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchStaff (string $staff_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStaff(["staff_name" => $staff_name]);
    }

    /**
     * 查询零售产品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductList (int $storeId, array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList(["storeId" => $storeId, "skuIds" => $skuIds]);
    }

    /**
     * 查询门店列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreByCity () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreByCity([]);
    }

    /**
     * sign
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function sign (string $upyun_key) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sign(["upyun_key" => $upyun_key]);
    }

    /**
     * BD组员工列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function bdStaffList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->bdStaffList([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}