<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-17 14:13:48
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Preferential
 * @method exportPreferentialListByParams(array $params) 导出券码列表
 * @method getPreferentialUseInfoByParams(array $params) 获取券码使用详情
 * @method exportPreferentialUseInfoPartByParams(array $params) 导出券码使用详情(部分)
 * @method exportPreferentialUseInfoByParams(array $params) 导出券码使用详情(全部)
 * @method allGiftCardCoverByParams(array $params) 获取礼品卡卡面列表(全部)
 * @method batchAbolishByParams(array $params) 批量券码作废
 * @method getGiftCardCoverByStoreIdByParams(array $params) 获取门店1030店铺实体礼品卡面信息
 * @method getProductCardByStoreIdByParams(array $params) 获取门店1030店铺实体产品卡信息
 */
class Preferential {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Preferential";

    /**
     * 导出券码列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function exportPreferentialList (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPreferentialList(["order_id" => $order_id]);
    }

    /**
     * 获取券码使用详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPreferentialUseInfo (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialUseInfo(["order_id" => $order_id]);
    }

    /**
     * 导出券码使用详情(部分)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function exportPreferentialUseInfoPart (int $order_id, array $search_info = [], string $white_list = '', int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPreferentialUseInfoPart(["order_id" => $order_id, "search_info" => $search_info, "white_list" => $white_list, "page" => $page, "page_size" => $page_size]);
    }

    /**
     * 导出券码使用详情(全部)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function exportPreferentialUseInfo (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPreferentialUseInfo(["order_id" => $order_id]);
    }

    /**
     * 获取礼品卡卡面列表(全部)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function allGiftCardCover (bool $has_topic_info = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allGiftCardCover(["has_topic_info" => $has_topic_info]);
    }

    /**
     * 批量券码作废
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchAbolish (int $order_id, array $codes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAbolish(["order_id" => $order_id, "codes" => $codes]);
    }

    /**
     * 获取门店1030店铺实体礼品卡面信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getGiftCardCoverByStoreId (int $storeId = 1030) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGiftCardCoverByStoreId(["storeId" => $storeId]);
    }

    /**
     * 获取门店1030店铺实体产品卡信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductCardByStoreId (int $storeId = 1030) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardByStoreId(["storeId" => $storeId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}