<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method editOutShootPerformanceRealMoneyByParams(array $params)
 * @method editContractRemainMoneyByParams(array $params)
 * @method checkBillsWithoutOrderForZhaoShangByParams(array $params)
 */
class Tool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 外拍订单补差价异常处理：原因确认业绩前端跟后端保留位数不一致产生的资金问题
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  float $realMoney 真实价格 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editOutShootPerformanceRealMoney () {
        return self::getClass()->editOutShootPerformanceRealMoney([
        ]);
    }

    /**
     * 编辑合同剩余金额
     *
     * @support  string $contractNo 合同号 [ require true ]
     * @support  float $changeMoney 变更金额+为加，-为减 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editContractRemainMoney () {
        return self::getClass()->editContractRemainMoney([
        ]);
    }

    /**
     * 核对招商bill
     *
     * @support  array $bankAccountFluentNums 银行账号以_拼接流水号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkBillsWithoutOrderForZhaoShang () {
        return self::getClass()->checkBillsWithoutOrderForZhaoShang([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Tool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Tool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}