<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method enableByParams(array $params)
 * @method detailByParams(array $params)
 * @method grantRoleByParams(array $params)
 * @method grantPermissionsByParams(array $params)
 * @method searchStaffByParams(array $params)
 */
class Manager {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取管理员列表
     *
     * @support  string $staffName 姓名或花名 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Manager\ManagerList\ListDTO
     */
    public static function list (int $page = 1, int $pageSize = 15) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Manager\ManagerList\ListDTO"
        );
    }

    /**
     * 创建管理员
     *
     * @support  int $staffId 员工id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 修改管理员启用状态
     *
     * @param  int $staffId 员工id [ require true ]
     * @param  int $status 状态 1:开启 2关闭 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enable (int $staffId, int $status) {
        return self::getClass()->enable([
            "staffId" => $staffId,
            "status" => $status,
        ]);
    }

    /**
     * 获取管理员
     *
     * @param  int $id 管理员ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Manager\Detail\DetailDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Manager\Detail\DetailDTO"
        );
    }

    /**
     * 给管理员授权角色
     *
     * @param  int $id 管理员ID [ require true ]
     * @param  array $roleIds 角色ID数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function grantRole (int $id, array $roleIds) {
        return self::getClass()->grantRole([
            "id" => $id,
            "roleIds" => $roleIds,
        ]);
    }

    /**
     * 给管理员授权权限
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @param  array $permissionIds 权限数组 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function grantPermissions (int $staffId, array $permissionIds = []) {
        return self::getClass()->grantPermissions([
            "staffId" => $staffId,
            "permissionIds" => $permissionIds,
        ]);
    }

    /**
     * 通过伙伴姓名或花名获得可能的工号
     *
     * @param  string $staffName 伙伴姓名或花名 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchStaff (string $staffName) {
        return self::getClass()->searchStaff([
            "staffName" => $staffName,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Manager');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Manager');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}