<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderListByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method payOrderByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method editOrderByParams(array $params)
 * @method payOrderFinalByParams(array $params)
 * @method getPurchaseInfoByParams(array $params)
 * @method codeStatusCountByParams(array $params)
 * @method cancelByParams(array $params)
 * @method abolishByLogIdByParams(array $params)
 * @method outShootFinishedByParams(array $params)
 * @method outShootSendQuestionByParams(array $params)
 * @method getPhotoOrderByParams(array $params)
 * @method batchUpdatePhotoOrderStoreByParams(array $params)
 * @method getRejectPhotoOrderListByOrderIdByParams(array $params)
 * @method unextractGroupOrderCountByParams(array $params)
 * @method getOrderInfoByIdByParams(array $params)
 * @method addCardApplyByParams(array $params)
 * @method cancelOrderByParams(array $params)
 * @method confirmOrderByParams(array $params)
 * @method addCardConfirmByParams(array $params)
 * @method cancelShootOrderDetailByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询订单
     *
     * @support  string $orderStatus 订单状态 [ require false ]
     * @support  string $paymentStatus 付款类型 [ require false ]
     * @support  string $contractNo 订单的合同编号 [ require false ]
     * @support  string $orderNo 订单编号 [ require false ]
     * @support  string $customerPhone 联系电话 [ require false ]
     * @support  string $link 联系人 [ require false ]
     * @support  string $enterpriseName 企业名称 [ require false ]
     * @support  int $enterpriseId 企业id [ require false ]
     * @support  int $creatorId 创建人id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @support  string $orderType 订单类型 [ require true ]
     * @support  bool $isSpecialOrder 是否是非合同订单 [ require false ]
     * @support  int $contractId 合同id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\OrderList\OrderListDTO
     */
    public static function orderList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderList([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\OrderList\OrderListDTO"
        );
    }

    /**
     * 订单详情
     *
     * @support  int $orderId 订单id [ require false ]
     * @support  int $id 订单合同id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\OrderDetail\OrderDetailDTO
     */
    public static function orderDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderDetail([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\OrderDetail\OrderDetailDTO"
        );
    }

    /**
     * 新增订单
     *
     * @support  int $contractId 合同id [ require false ]
     * @support  string $customerPhone 客户手机号 [ require false ]
     * @support  string $enterpriseName 企业名称 [ require false ]
     * @support  string $link 联系人姓名 [ require false ]
     * @support  int $contractArea 下单地区 [ require false ]
     * @support  int $enterpriseId 企业id [ require false ]
     * @support  string $customerType 顾客类型，old_customer/new_customer [ require false ]
     * @support  string $orderType 订单类型 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  array $purchaseInfo 购买内容 [ require false ]
     * @support  string $consumeMethod 核销方式 [ require false ]
     * @support  int $whiteListId 白名单id [ require false ]
     * @support  string $remark 订单备注 [ require false ]
     * @support  string $advanced 是否分期 [ require false ]
     * @support  float $originPrice 订单原价 [ require true ]
     * @support  float $realPay 订单实际支付 [ require true ]
     * @support  float $discount 折扣 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @support  bool $isSpecialOrder 是否是非合同订单 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\CreateOrder\CreateOrderDTO
     */
    public static function createOrder () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createOrder([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\CreateOrder\CreateOrderDTO"
        );
    }

    /**
     * 确认支付
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $accountId 资金账户id [ require true ]
     * @support  float $payOrderMoney 实际支付金额 [ require true ]
     * @support  float $creditOrderMoney 授信额度抵扣金额 [ require true ]
     * @support  bool $isSpecialOrder 是否是非合同订单 [ require false ]
     * @support  string $orderType 订单类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function payOrder () {
        return self::getClass()->payOrder([
        ]);
    }

    /**
     * 删除订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  bool $isSpecialOrder 是否是非合同订单 [ require false ]
     * @support  string $orderType 订单类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteOrder () {
        return self::getClass()->deleteOrder([
        ]);
    }

    /**
     * 编辑订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $customerPhone 客户手机号 [ require false ]
     * @support  string $enterpriseName 企业名称 [ require false ]
     * @support  string $link 联系人姓名 [ require false ]
     * @support  int $contractArea 下单地区 [ require false ]
     * @support  int $enterpriseId 企业id [ require false ]
     * @support  string $customerType 顾客类型，old_customer/new_customer [ require false ]
     * @support  string $orderType 订单类型 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  array $purchaseInfo 购买内容 [ require false ]
     * @support  string $consumeMethod 核销方式 [ require false ]
     * @support  int $whiteListId 白名单id [ require false ]
     * @support  string $remark 订单备注 [ require false ]
     * @support  string $advanced 是否分期 [ require false ]
     * @support  float $originPrice 订单原价 [ require true ]
     * @support  float $realPay 订单实际支付 [ require true ]
     * @support  float $discount 折扣 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @support  bool $isSpecialOrder 是否是非合同订单 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editOrder () {
        return self::getClass()->editOrder([
        ]);
    }

    /**
     * 支付尾款
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $pay_at 付款日期 [ require false ]
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  float $final_pay_money 尾款 [ require true ]
     * @support  array $evidence 支付凭证 [ require true ]
     * @support  string $fluent_num 流水号 [ require false ]
     * @support  array $change_info 购买物变更信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payOrderFinal () {
        return self::getClass()->payOrderFinal([
        ]);
    }

    /**
     * 获取订单购买详情
     *
     * @param  int $orderId 订单id [ require true ]
     * @support  bool $isSpecialOrder 是否是非合同订单 [ require false ]
     * @support  string $orderType 订单类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPurchaseInfo (int $orderId) {
        return self::getClass()->getPurchaseInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 券码订单中已提取券码状态数量
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\CodeStatusCount\CodeStatusCountDTO[]
     */
    public static function codeStatusCount () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->codeStatusCount([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\CodeStatusCount\CodeStatusCountDTO[]"
        );
    }

    /**
     * 取消订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $reason 取消原因 [ require false ]
     * @support  bool $isSpecialOrder 是否是非合同订单 [ require false ]
     * @support  string $orderType 订单类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancel () {
        return self::getClass()->cancel([
        ]);
    }

    /**
     * 根据创建记录作废券码
     *
     * @param  int $id 订单id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $createLogId 记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function abolishByLogId (int $id, string $type, int $createLogId) {
        return self::getClass()->abolishByLogId([
            "id" => $id,
            "type" => $type,
            "createLogId" => $createLogId,
        ]);
    }

    /**
     * 外拍订单退/补差价
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function outShootFinished () {
        return self::getClass()->outShootFinished([
        ]);
    }

    /**
     * 发送问卷调查表
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function outShootSendQuestion (int $id) {
        return self::getClass()->outShootSendQuestion([
            "id" => $id,
        ]);
    }

    /**
     * 获取关联拍摄订单列表
     *
     * @support  int $groupOrderId 团购订单ID [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\GetPhotoOrder\PhotoGetOrderDTO
     */
    public static function getPhotoOrder () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPhotoOrder([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\GetPhotoOrder\PhotoGetOrderDTO"
        );
    }

    /**
     * 修改拍摄门店
     *
     * @support  array $data 重新指定的拍摄门店数据集（如：[id=&gt;审批详情ID_1,store_id =&gt; 重新指定的门店ID_1,store_name =&gt; 重新指定的门店名称_1]） [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdatePhotoOrderStore () {
        return self::getClass()->batchUpdatePhotoOrderStore([
        ]);
    }

    /**
     * 获取门店驳回、取消订单列表
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\GetRejectPhotoOrderListByOrderId\RejectPhotoOrderListByOrderIdGetDTO[]
     */
    public static function getRejectPhotoOrderListByOrderId (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRejectPhotoOrderListByOrderId([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\GetRejectPhotoOrderListByOrderId\RejectPhotoOrderListByOrderIdGetDTO[]"
        );
    }

    /**
     * 获取未提取海马体订单的团购单数量
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\UnextractGroupOrderCount\UnextractGroupOrderCountDTO
     */
    public static function unextractGroupOrderCount () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->unextractGroupOrderCount([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\UnextractGroupOrderCount\UnextractGroupOrderCountDTO"
        );
    }

    /**
     * 根据订单ID获取卡信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\GetOrderInfoById\OrderInfoByIdDTO
     */
    public static function getOrderInfoById (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderInfoById([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\GetOrderInfoById\OrderInfoByIdDTO"
        );
    }

    /**
     * 添加卡片申请
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  array $purchaseInfo 卡片信息 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addCardApply () {
        return self::getClass()->addCardApply([
        ]);
    }

    /**
     * BD取消订单释放卡面
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelOrder () {
        return self::getClass()->cancelOrder([
        ]);
    }

    /**
     * BD确认收到货
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmOrder () {
        return self::getClass()->confirmOrder([
        ]);
    }

    /**
     * 财务确认激活卡片
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addCardConfirm () {
        return self::getClass()->addCardConfirm([
        ]);
    }

    /**
     * 取消拍摄订单列表页展示
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Order\CancelShootOrderDetail\CancelShootOrderDetailDTO[]
     */
    public static function cancelShootOrderDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->cancelShootOrderDetail([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Order\CancelShootOrderDetail\CancelShootOrderDetailDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}