<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method messageEventPushLogListByParams(array $params)
 * @method messageEventPushLogReadByParams(array $params)
 */
class MessageEventPushLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 系统通知日志列表
     *
     * @support  int $page 第几页 [ require false ]
     * @support  int $pageSize 每页多少条 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function messageEventPushLogList () {
        return self::getClass()->messageEventPushLogList([
        ]);
    }

    /**
     * 点击日志更新为已读
     *
     * @param  int $id 日志id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function messageEventPushLogRead (int $id) {
        return self::getClass()->messageEventPushLogRead([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\MessageEventPushLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\MessageEventPushLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}