<?php
namespace Mainto\Bridge\Structs\Business\DTO\Order;

class OrderDetailDTO {
    /**
     * @var  int
     */
    public int $id;
    /**
     * @var  string
     */
    public string $orderNo;
    /**
     * @var  int
     */
    public int $contractId;
    /**
     * @var  string
     */
    public string $brand;
    /**
     * @var  string
     */
    public string $cardStatus;
    /**
     * @var  array
     */
    public array $purchaseInfo;
    /**
     * @var  string
     */
    public string $orderType;
    /**
     * @var  float // origin: double
     */
    public float $originPrice;
    /**
     * @var  float // origin: double
     */
    public float $refundMoney;
    /**
     * @var  float // origin: double
     */
    public float $realPay;
    /**
     * @var  float // origin: double
     */
    public float $discount;
    /**
     * @var  string
     */
    public string $consumeMethod;
    /**
     * @var  string
     */
    public string $status;
    /**
     * @var  string
     */
    public string $paymentStatus;
    /**
     * @var  null|string
     */
    public ?string $advanced;
    /**
     * @var  null|string
     */
    public ?string $staffPay;
    /**
     * @var  null|string
     */
    public ?string $staffPhone;
    /**
     * @var  null|int
     */
    public ?int $whiteListId;
    /**
     * @var  int
     */
    public int $creatorId;
    /**
     * @var  null|array
     */
    public ?array $auditor;
    /**
     * @var  null|string
     */
    public ?string $passedAt;
    /**
     * @var  null|string
     */
    public ?string $remark;
    /**
     * @var  null|\Mainto\Bridge\Structs\Business\DTO\Order\OrderExtendDTO
     */
    public ?\Mainto\Bridge\Structs\Business\DTO\Order\OrderExtendDTO $extend;
    /**
     * @var  null|int
     */
    public ?int $bindContractId;
    /**
     * @var  null|int
     */
    public ?int $accountId;
    /**
     * @var  null|\Mainto\Bridge\Structs\Business\DTO\OutshootPerformance\OutshootPerformanceDetailDTO
     */
    public ?\Mainto\Bridge\Structs\Business\DTO\OutshootPerformance\OutshootPerformanceDetailDTO $outShootPerformance;
    /**
     * @var  null|\Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListDTO
     */
    public ?\Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListDTO $whiteList;
    /**
     * @var  null|\Mainto\Bridge\Structs\Business\DTO\Order\OrderList\ContractDTO
     */
    public ?\Mainto\Bridge\Structs\Business\DTO\Order\OrderList\ContractDTO $contract;
}