<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addEnterpriseByParams(array $params)
 * @method editEnterpriseByParams(array $params)
 * @method getEnterpriseListByParams(array $params)
 * @method getEnterpriseListByPermissionByParams(array $params)
 * @method getAllEnterpriseListByFilterByParams(array $params)
 * @method transferEnterpriseByParams(array $params)
 * @method getEnterpriseTransferLogByParams(array $params)
 * @method deleteEnterpriseByParams(array $params)
 * @method getEnterpriseByParams(array $params)
 * @method getEnterpriseByNameByParams(array $params)
 * @method getEnterpriseInfoByParams(array $params)
 * @method checkEnterpriseOrderStatusByParams(array $params)
 * @method getEnterpriseNameByQccByParams(array $params)
 * @method getEnterpriseByStaffIdByParams(array $params)
 */
class Enterprise {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加企业
     *
     * @support  string $enterprise_name 企业名称 [ require false ]
     * @support  string $type 企业类型 [ require false ]
     * @support  string $title 抬头 [ require false ]
     * @support  string $tax_num 税号 [ require false ]
     * @support  string $enterprise_address 企业地址 [ require false ]
     * @support  string $bank 开户行 [ require false ]
     * @support  string $bank_account 开户行账号 [ require false ]
     * @support  string $from 来源 [ require false ]
     * @support  string $trade 行业 [ require false ]
     * @support  string $area 地区 [ require false ]
     * @support  string $social_credit_code 社会信用编码 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @support  string $key_no KeyNo [ require false ]
     * @support  string $start_date 成立日期 [ require false ]
     * @support  string $oper_name 法定代表人姓名 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $no 注册号 [ require false ]
     * @support  string $enterprise_level 企业等级 [ require false ]
     * @support  string $contacts 联系人 [ require false ]
     * @support  string $contact_number 联系电话 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addEnterprise () {
        return self::getClass()->addEnterprise([
        ]);
    }

    /**
     * 编辑企业
     *
     * @support  int $enterprise_id 企业id [ require false ]
     * @support  string $enterprise_name 企业名称 [ require false ]
     * @support  string $type 企业名称 [ require false ]
     * @support  string $title 抬头 [ require false ]
     * @support  string $tax_num 税号 [ require false ]
     * @support  string $enterprise_address 企业地址 [ require false ]
     * @support  string $bank 开户行 [ require false ]
     * @support  string $bank_account 开户行账号 [ require false ]
     * @support  string $from 来源 [ require false ]
     * @support  string $trade 行业 [ require false ]
     * @support  string $area 地区 [ require false ]
     * @support  string $social_credit_code 社会信用编码 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  string $key_no KeyNo [ require false ]
     * @support  string $start_date 成立日期 [ require false ]
     * @support  string $oper_name 法定代表人姓名 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $no 注册号 [ require false ]
     * @support  string $enterprise_level 企业等级 [ require false ]
     * @support  string $contacts 联系人 [ require false ]
     * @support  string $contact_number 联系电话 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editEnterprise () {
        return self::getClass()->editEnterprise([
        ]);
    }

    /**
     * 企业列表
     *
     * @support  string $enterprise_name 企业名称 [ require false ]
     * @support  int $belong_staff_id 归属人staff_id [ require false ]
     * @support  string $from 来源 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @support  string $enterprise_level 客户等级 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterpriseList () {
        return self::getClass()->getEnterpriseList([
        ]);
    }

    /**
     * 通过身份获取企业列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getEnterpriseListByPermission () {
        return self::getClass()->getEnterpriseListByPermission();
    }

    /**
     * 获取企业列表(分页)
     *
     * @support  string $enterpriseName 企业名称 [ require false ]
     * @support  int $belongStaff 归属人工号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllEnterpriseListByFilter () {
        return self::getClass()->getAllEnterpriseListByFilter([
        ]);
    }

    /**
     * 转移客户
     *
     * @support  array $enterprise_ids 一批企业 [ require false ]
     * @support  int $receive_staff 接收人 [ require false ]
     * @support  bool $all_transfer 是否全部转移 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function transferEnterprise () {
        return self::getClass()->transferEnterprise([
        ]);
    }

    /**
     * 企业归属记录
     *
     * @support  int $enterprise_id 企业id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterpriseTransferLog () {
        return self::getClass()->getEnterpriseTransferLog([
        ]);
    }

    /**
     * 删除企业
     *
     * @param  int $enterprise_id 企业id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function deleteEnterprise (int $enterprise_id) {
        return self::getClass()->deleteEnterprise([
            "enterprise_id" => $enterprise_id,
        ]);
    }

    /**
     * 根据名称或者企业组id获取企业
     *
     * @param  string $enterprise_name 企业名称(模糊匹配) [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterprise (string $enterprise_name = '') {
        return self::getClass()->getEnterprise([
            "enterprise_name" => $enterprise_name,
        ]);
    }

    /**
     * 根据名称或者企业id获取企业
     *
     * @param  string $enterprise_name 企业名称(精准匹配) [ require false ]
     * @param  int $enterprise_id 企业id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterpriseByName (string $enterprise_name = '', int $enterprise_id = 0) {
        return self::getClass()->getEnterpriseByName([
            "enterprise_name" => $enterprise_name,
            "enterprise_id" => $enterprise_id,
        ]);
    }

    /**
     * 根据企业id获取企业信息
     *
     * @param  int $enterprise_id 企业id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterpriseInfo (int $enterprise_id) {
        return self::getClass()->getEnterpriseInfo([
            "enterprise_id" => $enterprise_id,
        ]);
    }

    /**
     * 同步拍摄订单拍摄状态
     *
     * @support  int $enterprise_id 企业id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkEnterpriseOrderStatus () {
        return self::getClass()->checkEnterpriseOrderStatus([
        ]);
    }

    /**
     * 通过企查查获取企业信息
     *
     * @support  string $enterpriseName 企业名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterpriseNameByQcc () {
        return self::getClass()->getEnterpriseNameByQcc([
        ]);
    }

    /**
     * 通过staffId获取七日未跟进的企业
     *
     * @support  int $staffId 企业ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterpriseByStaffId () {
        return self::getClass()->getEnterpriseByStaffId([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Enterprise');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Enterprise');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}