<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method createNoLoginByParams(array $params)
 */
class DailyLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建跟进记录
     *
     * @support  int $enterpriseId 企业id [ require true ]
     * @support  string $workLogType 跟进形式 [ require true ]
     * @support  string $workLogTime 跟进时间 [ require true ]
     * @support  array $workLogInfo 跟进内容 [ require true ]
     * @support  string $enterpriseLevel 企业等级 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\DailyLog\Create\DailyLogCreateDTO
     */
    public static function create () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\DailyLog\Create\DailyLogCreateDTO"
        );
    }

    /**
     * 跟进记录列表
     *
     * @param  int $enterpriseId 企业id [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\DailyLog\DailyLogList\DailyLogListDTO
     */
    public static function list (int $enterpriseId, int $page = 1, int $pageSize = 15) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                            "enterpriseId" => $enterpriseId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\DailyLog\DailyLogList\DailyLogListDTO"
        );
    }

    /**
     * H5未登陆状态创建跟进记录
     *
     * @support  int $enterpriseId 企业id [ require true ]
     * @support  string $workLogType 跟进形式 [ require true ]
     * @support  string $workLogTime 跟进时间 [ require true ]
     * @support  array $workLogInfo 跟进内容 [ require true ]
     * @support  int $staffId 跟进人工号 [ require true ]
     * @support  string $enterpriseLevel 企业等级 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\DailyLog\CreateNoLogin\NoLoginCreateDTO
     */
    public static function createNoLogin () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createNoLogin([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\DailyLog\CreateNoLogin\NoLoginCreateDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\DailyLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\DailyLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}