<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method addByParams(array $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method sendMsgByParams(array $params)
 */
class WhiteList {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建白名单
     *
     * @param  array $whiteListTable 白名单表格[{&#039;whiteList&#039;:1},{&#039;whiteList&#039;:2}] [ require true ]
     * @param  string $type 白名单类型 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListCreateDTO
     */
    public static function create (array $whiteListTable, string $type) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create([
                            "whiteListTable" => $whiteListTable,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListCreateDTO"
        );
    }

    /**
     * 新增白名单
     *
     * @param  array $whiteListTable 白名单表格[{&#039;whiteList&#039;:1},{&#039;whiteList&#039;:2}] [ require true ]
     * @param  int $whiteListId 白名单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListAddDTO
     */
    public static function add (array $whiteListTable, int $whiteListId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->add([
                            "whiteListTable" => $whiteListTable,
                            "whiteListId" => $whiteListId,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\WhiteList\WhiteListAddDTO"
        );
    }

    /**
     * 删除白名单指定内容
     *
     * @param  array $contentIds 白名单内容id数组 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function delete (array $contentIds) {
        return self::getClass()->delete([
            "contentIds" => $contentIds,
        ]);
    }

    /**
     * 获取白名单详情
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $whiteList 白名单信息 [ require false ]
     * @param  int $page page [ require false ]
     * @param  int $pageSize page_size [ require false ]
     * @param  bool $withSendInfo 是否包含判断白名单是否全部发送 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\WhiteList\DetailDTO
     */
    public static function detail (int $orderId, int $page = 1, int $pageSize = 20, string $whiteList = '', bool $withSendInfo = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "orderId" => $orderId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                            "whiteList" => $whiteList,
                            "withSendInfo" => $withSendInfo,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\WhiteList\DetailDTO"
        );
    }

    /**
     * 发送通知
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $url 跳转地址 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendMsg (int $orderId, string $url) {
        return self::getClass()->sendMsg([
            "orderId" => $orderId,
            "url" => $url,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\WhiteList');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\WhiteList');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}