<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method applyInvoiceByParams(array $params)
 * @method invoiceDetailByParams(array $params)
 * @method deleteInvoiceByParams(array $params)
 * @method invoiceListByParams(array $params)
 * @method saleTaxNumListByParams(array $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 申请开票
     *
     * @support  string $invoiceType 发票类型(paper_invoice|electronic_invoice) [ require false ]
     * @support  string $titleType 抬头类型(person|company) [ require false ]
     * @support  string $type 抬头类型(general_invoice|special_invoice) [ require false ]
     * @support  bool $isNow 是否立即开具 [ require false ]
     * @support  string $title 购方名称 [ require true ]
     * @support  string $phone 购方手机 (开票成功会短信提醒购方) [ require false ]
     * @support  string $taxnum 购方税号(18/20位) [ require false ]
     * @support  string $saletaxnum 销方税号(18/20位) [ require false ]
     * @support  int $contractId 合同id [ require true ]
     * @support  array $detail 电子发票明细 [ require false ]
     * @support  string $telephone 购方电话 [ require false ]
     * @support  string $address 购方地址 [ require false ]
     * @support  string $account 购方银行账号(和开户行合在一起) [ require false ]
     * @support  string $email 推送邮箱 [ require false ]
     * @support  string $message 备注信息 [ require false ]
     * @support  string $deliveryArea 收货省市区信息 [ require false ]
     * @support  string $deliveryAddress 收货详细地址信息 [ require false ]
     * @support  string $deliveryPeople 收货人 [ require false ]
     * @support  string $deliveryPhone 收货手机 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function applyInvoice () {
        return self::getClass()->applyInvoice([
        ]);
    }

    /**
     * 发票详情
     *
     * @support  int $id 申请开票id(不是发票id) [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Invoice\InvoiceDetail\InvoiceDetailDTO
     */
    public static function invoiceDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->invoiceDetail([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Invoice\InvoiceDetail\InvoiceDetailDTO"
        );
    }

    /**
     * 发票删除
     *
     * @support  int $id 发票id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteInvoice () {
        return self::getClass()->deleteInvoice([
        ]);
    }

    /**
     * 开票记录
     *
     * @param  int $id 合同id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Invoice\InvoiceList\InvoiceListDTO
     */
    public static function invoiceList (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->invoiceList([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Invoice\InvoiceList\InvoiceListDTO"
        );
    }

    /**
     * 获取销方
     *
     * @support  int $enterpriseId 企业ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Invoice\SaleTaxNumList\SaleTaxNumListDTO[]
     */
    public static function saleTaxNumList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->saleTaxNumList([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Invoice\SaleTaxNumList\SaleTaxNumListDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}