<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method workStationIndexByParams(array $params)
 * @method polylineDataByParams(array $params)
 * @method polylineDataManagerByParams(array $params)
 * @method getPaymentInfoByParams(array $params)
 * @method getCurrentMonthRankByParams(array $params)
 * @method getStaffRankInfoByParams(array $params)
 * @method deleteMultipleByParams(array $params)
 * @method getDepartmentTreeByParams(array $params)
 * @method clueConversionByParams(array $params)
 * @method orderConstituteByParams(array $params)
 */
class WorkStation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 头部信息
     *
     * @support  int $departmentId 部门ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function workStationIndex () {
        return self::getClass()->workStationIndex([
        ]);
    }

    /**
     * 首页折线数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function polylineData () {
        return self::getClass()->polylineData();
    }

    /**
     * 首页折线经理/主管数据数据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function polylineDataManager () {
        return self::getClass()->polylineDataManager();
    }

    /**
     * 资金状况经理/普通BD
     *
     * @support  int $departmentId 部门ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPaymentInfo () {
        return self::getClass()->getPaymentInfo([
        ]);
    }

    /**
     * 缓冲中获取工作台排名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCurrentMonthRank () {
        return self::getClass()->getCurrentMonthRank();
    }

    /**
     * 缓冲中获取工作台登陆人排名信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffRankInfo () {
        return self::getClass()->getStaffRankInfo();
    }

    /**
     * 删除指定缓存接口
     *
     * @param  array $keys 缓存keys [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteMultiple (array $keys) {
        return self::getClass()->deleteMultiple([
            "keys" => $keys,
        ]);
    }

    /**
     * 部门分组
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDepartmentTree () {
        return self::getClass()->getDepartmentTree();
    }

    /**
     * 线索转换
     *
     * @support  int $departmentId 部门ID [ require true ]
     * @support  string $limitMonth 线索时间 [ require true ]
     * @support  string $from 线索渠道 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clueConversion () {
        return self::getClass()->clueConversion([
        ]);
    }

    /**
     * 订单构成
     *
     * @support  int $departmentId 部门ID [ require true ]
     * @support  string $limitMonth 线索时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderConstitute () {
        return self::getClass()->orderConstitute([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\WorkStation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\WorkStation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}