<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method exportPreferentialListByParams(array $params)
 * @method getPreferentialUseInfoByParams(array $params)
 * @method exportPreferentialUseInfoByParams(array $params)
 * @method allGiftCardCoverByParams(array $params)
 * @method batchAbolishByParams(array $params)
 * @method getGiftCardCoverByStoreIdByParams(array $params)
 * @method getProductCardByStoreIdByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 导出券码列表
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Preferential\PreferentialExportPreferentialListDTO[]
     */
    public static function exportPreferentialList (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->exportPreferentialList([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Preferential\PreferentialExportPreferentialListDTO[]"
        );
    }

    /**
     * 获取券码使用详情
     *
     * @param  array $searchInfo 券码创建记录id数组,[[&#039;create_log_id&#039;=&gt;1,&#039;type&#039;=&gt;&#039;coupon&#039;,&#039;amount&#039; =&gt;1]] [ require false ]
     * @param  int $orderId 订单id [ require true ]
     * @param  string $whiteList 白名单内容，手机号/邮箱/券码 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Preferential\PreferentialGetPreferentialUseInfoDTO
     */
    public static function getPreferentialUseInfo (int $orderId, array $searchInfo = [], string $whiteList = '', int $page = 1, int $pageSize = 20) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPreferentialUseInfo([
                            "orderId" => $orderId,
                            "searchInfo" => $searchInfo,
                            "whiteList" => $whiteList,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Preferential\PreferentialGetPreferentialUseInfoDTO"
        );
    }

    /**
     * 导出券码使用详情
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Preferential\PreferentialExportPreferentialUseInfoDTO
     */
    public static function exportPreferentialUseInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->exportPreferentialUseInfo([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Preferential\PreferentialExportPreferentialUseInfoDTO"
        );
    }

    /**
     * 获取礼品卡卡面列表(全部)
     *
     * @support  int $topic_id 主题ids [ require false ]
     * @support  string $title 卡面标题 [ require false ]
     * @support  bool $has_topic_info 是否包含主题信息 [ require false ]
     * @support  bool $is_on_sale 是否在售 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allGiftCardCover () {
        return self::getClass()->allGiftCardCover([
        ]);
    }

    /**
     * 批量券码作废
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  array $codes 券码组(带类型) [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchAbolish () {
        return self::getClass()->batchAbolish([
        ]);
    }

    /**
     * 获取门店1030店铺实体礼品卡面信息
     *
     * @param  int $storeId 门店ID [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Preferential\PreferentialGetGiftCardCoverByStoreIdDTO[]
     */
    public static function getGiftCardCoverByStoreId (int $storeId = 1030) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getGiftCardCoverByStoreId([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Preferential\PreferentialGetGiftCardCoverByStoreIdDTO[]"
        );
    }

    /**
     * 获取门店1030店铺实体产品卡信息
     *
     * @param  int $storeId 门店ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCardByStoreId (int $storeId = 1030) {
        return self::getClass()->getProductCardByStoreId([
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}