<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method exportPreferentialNosByParams(array $params)
 */
class EnterprisePreferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建客情维护客户优惠卡申请
     *
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  float $ori_money 礼品卡面额 [ require true ]
     * @support  int $count 申请数量 [ require true ]
     * @support  string $reason 申请原因 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 获取客情维护客户申请优惠列表
     *
     * @param  int $enterprise_id 企业id [ require true ]
     * @param  int $page 页数 [ require false ]
     * @param  int $page_size 每页行数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $enterprise_id, int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "enterprise_id" => $enterprise_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 优惠卷导出
     *
     * @support  int $id 优惠卷订单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function exportPreferentialNos () {
        return self::getClass()->exportPreferentialNos([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\EnterprisePreferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\EnterprisePreferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}