<?php
namespace Mainto\Bridge\Invokes\Business\Customer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method editContentByParams(array $params)
 * @method detailContentByParams(array $params)
 */
class Questionnaire {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 填写问卷
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  array $content 问卷内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editContent () {
        return self::getClass()->editContent([
        ]);
    }

    /**
     * 获取问卷是否可以填写
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Questionnaire\QuestionnaireDTO
     */
    public static function detailContent () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detailContent([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Questionnaire\QuestionnaireDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Customer\Questionnaire');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Customer\Questionnaire');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}