<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method addByParams(array $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method sendMsgByParams(array $params)
 */
class WhiteList {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建白名单
     *
     * @param  array $white_list_table 白名单表格[{&#039;white_list&#039;:1},{&#039;white_list&#039;:2}] [ require true ]
     * @param  string $type 白名单类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (array $white_list_table, string $type) {
        return self::getClass()->create([
            "white_list_table" => $white_list_table,
            "type" => $type,
        ]);
    }

    /**
     * 新增白名单
     *
     * @param  array $white_list_table 白名单表格[{&#039;white_list&#039;:1},{&#039;white_list&#039;:2}] [ require true ]
     * @param  int $white_list_id 白名单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add (array $white_list_table, int $white_list_id) {
        return self::getClass()->add([
            "white_list_table" => $white_list_table,
            "white_list_id" => $white_list_id,
        ]);
    }

    /**
     * 删除白名单指定内容
     *
     * @param  array $content_ids 白名单内容id数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (array $content_ids) {
        return self::getClass()->delete([
            "content_ids" => $content_ids,
        ]);
    }

    /**
     * 获取白名单详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $white_list 白名单信息 [ require false ]
     * @param  int $page page [ require false ]
     * @param  int $page_size page_size [ require false ]
     * @param  bool $with_send_info 是否包含判断白名单是否全部发送 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\WhiteList\DetailDTO
     */
    public static function detail (int $order_id, int $page = 1, int $page_size = 20, string $white_list = '', bool $with_send_info = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "order_id" => $order_id,
                            "page" => $page,
                            "page_size" => $page_size,
                            "white_list" => $white_list,
                            "with_send_info" => $with_send_info,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\WhiteList\DetailDTO"
        );
    }

    /**
     * 发送通知
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $url 跳转地址 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendMsg (int $orderId, string $url) {
        return self::getClass()->sendMsg([
            "orderId" => $orderId,
            "url" => $url,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\WhiteList');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\WhiteList');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}