<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 */
class CreditApplyLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授信额度申请
     *
     * @param  int $enterpriseId 企业id [ require true ]
     * @param  string $type 授信类型 [ require true ]
     * @param  float $money 授信金额 [ require true ]
     * @param  string $note 申请理由 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\CreditApplyLog\CreateDTO
     */
    public static function create (int $enterpriseId, string $type, float $money, string $note) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create([
                            "enterpriseId" => $enterpriseId,
                            "type" => $type,
                            "money" => $money,
                            "note" => $note,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\CreditApplyLog\CreateDTO"
        );
    }

    /**
     * 授信额度申请列表
     *
     * @param  int $enterpriseId 企业id [ require true ]
     * @param  string $type 授信类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\CreditApplyLog\ListDTO
     */
    public static function list (int $enterpriseId, string $type = '', int $page = 1, int $pageSize = 15) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                            "enterpriseId" => $enterpriseId,
                            "type" => $type,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\CreditApplyLog\ListDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\CreditApplyLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\CreditApplyLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}