<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method calProductCardPriceByParams(array $params)
 * @method areaAllByParams(array $params)
 * @method getAllPackageByParams(array $params)
 * @method getSubPackageWithPriceAreasByParams(array $params)
 * @method listStoreIdsBySubPackageIdsByParams(array $params)
 * @method listProductInfoBySubPackageIdsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Product\ProductDetailDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Product\ProductDetailDTO"
        );
    }

    /**
     * 计算产品卡价格
     *
     * @param  array $limit 模版limit [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calProductCardPrice (array $limit) {
        return self::getClass()->calProductCardPrice([
            "limit" => $limit,
        ]);
    }

    /**
     * 所有门店分区
     *
     * @param  string $module 价格区所属品牌 [ require true ]
     * @param  string $type 分区类型(价格区,服装区)(不传表示全部) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaAll (string $module, string $type = '') {
        return self::getClass()->areaAll([
            "module" => $module,
            "type" => $type,
        ]);
    }

    /**
     * 获取所有套餐
     *
     * @support  array $modules 所属模块组 [ require false ]
     * @support  string $name 套餐名称 [ require false ]
     * @support  array $status 状态 [ require false ]
     * @support  array $packageIds 套餐ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllPackage () {
        return self::getClass()->getAllPackage([
        ]);
    }

    /**
     * 获取制定套餐区域价格
     *
     * @support  array $subPackageIds 子套餐id [ require true ]
     * @support  bool $calcPeopleNumMax 是否按最大人数计算 [ require true ]
     * @support  array $areaIds 价格区ids [ require false ]
     * @support  array $storeIds 门店Ids [ require false ]
     * @throws  \Exception
     * @return  double
     */
    public static function getSubPackageWithPriceAreas () {
        return self::getClass()->getSubPackageWithPriceAreas([
        ]);
    }

    /**
     * 子套餐可用门店列表
     *
     * @support  array $subPackageIds 产品ID合集 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listStoreIdsBySubPackageIds () {
        return self::getClass()->listStoreIdsBySubPackageIds([
        ]);
    }

    /**
     * 通过子套餐ids获取可售卖产品规则
     *
     * @support  array $subPackageIds 子套餐ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listProductInfoBySubPackageIds () {
        return self::getClass()->listProductInfoBySubPackageIds([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}