<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method contractListByParams(array $params)
 * @method yearContractListByParams(array $params)
 * @method getBindContractListByParams(array $params)
 * @method bindYearContractListByParams(array $params)
 * @method createContractByParams(array $params)
 * @method createYearContractByParams(array $params)
 * @method contractDetailByParams(array $params)
 * @method yearContractDetailByParams(array $params)
 * @method editContractByParams(array $params)
 * @method deleteContractByParams(array $params)
 * @method uploadFinalFileByParams(array $params)
 * @method getBindOrdersByParams(array $params)
 * @method syncUpdateContractByParams(array $params)
 * @method syncCreateContractByParams(array $params)
 */
class Contract {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询业务合同
     *
     * @support  string $startAt 开始日期 [ require false ]
     * @support  string $endAt 结束日期 [ require false ]
     * @support  string $enterpriseName 企业名称 [ require false ]
     * @support  string $customerPhone 客户手机号 [ require false ]
     * @param  int $creatorId 创建人 [ require false ]
     * @support  bool $isFinalContract 是否为盖印合同 [ require false ]
     * @support  string $contractType 合同类型，year_contract/normal_contract [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @support  string $contractNo 合同号 [ require false ]
     * @param  string $descSortColumn 以什么字段倒序 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\ContractList\ContractListDTO
     */
    public static function contractList (int $creatorId = 0, int $page = 1, int $pageSize = 10, string $descSortColumn = 'created_at') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contractList([
                            "creatorId" => $creatorId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                            "descSortColumn" => $descSortColumn,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\ContractList\ContractListDTO"
        );
    }

    /**
     * 查询框架合同
     *
     * @support  string $startAt 生效开始日期 [ require false ]
     * @support  string $endAt 生效结束日期 [ require false ]
     * @support  string $createStartAt 创建开始日期 [ require false ]
     * @support  string $createEndAt 创建结束日期 [ require false ]
     * @support  string $enterpriseName 企业名称 [ require false ]
     * @support  string $customerPhone 客户手机号 [ require false ]
     * @param  int $creatorId 创建人 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @support  string $contractNo 合同号 [ require false ]
     * @param  string $descSortColumn 以什么字段倒序 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\YearContractList\YearContractListDTO
     */
    public static function yearContractList (int $creatorId = 0, int $page = 1, int $pageSize = 10, string $descSortColumn = 'created_at') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->yearContractList([
                            "creatorId" => $creatorId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                            "descSortColumn" => $descSortColumn,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\YearContractList\YearContractListDTO"
        );
    }

    /**
     * 获取可以绑定业务合同
     *
     * @support  int $enterpriseId 企业id [ require false ]
     * @support  string $enterpriseName 企业名称 [ require false ]
     * @param  string $descSortColumn 以什么字段倒序 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\BindContractList\BindContractListDTO
     */
    public static function getBindContractList (string $descSortColumn = 'passed_at') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBindContractList([
                            "descSortColumn" => $descSortColumn,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\BindContractList\BindContractListDTO"
        );
    }

    /**
     * 获取绑定框架合同
     *
     * @support  string $enterpriseName 企业名称 [ require false ]
     * @support  bool $isFinalContract 是否为盖印合同 [ require false ]
     * @support  string $contractNo 合同号 [ require false ]
     * @param  string $descSortColumn 以什么字段倒序 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\BindYearContractList\BindYearContractListDataDTO[]
     */
    public static function bindYearContractList (string $descSortColumn = 'created_at') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bindYearContractList([
                            "descSortColumn" => $descSortColumn,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\BindYearContractList\BindYearContractListDataDTO[]"
        );
    }

    /**
     * 创建业务合同
     *
     * @support  string $customerPhone 客户手机号 [ require true ]
     * @support  string $enterpriseName 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contractArea 下单地区 [ require true ]
     * @support  int $enterpriseId 企业id [ require true ]
     * @support  float $contractMoney 合同金额 [ require true ]
     * @support  string $customerType 顾客类型，old_customer/new_customer [ require false ]
     * @support  string $contractFilePath 合同地址 [ require true ]
     * @support  string $contractFileName 合同名称 [ require true ]
     * @support  string $remark 合同备注 [ require false ]
     * @support  array $discountInfo 折扣 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\CreateContract\CreateContractDTO
     */
    public static function createContract () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createContract([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\CreateContract\CreateContractDTO"
        );
    }

    /**
     * 创建框架合同
     *
     * @support  string $customerPhone 客户手机号 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contractArea 下单地区 [ require true ]
     * @support  int $enterpriseId 企业id [ require true ]
     * @support  string $customerType 顾客类型，old_customer/new_customer [ require false ]
     * @support  string $contractFilePath 合同地址 [ require true ]
     * @support  string $contractFileName 合同名称 [ require true ]
     * @support  string $startAt 框架生效时间 [ require false ]
     * @support  string $endAt 框架结束时间 [ require false ]
     * @support  string $contractFileName 合同名称 [ require true ]
     * @support  string $remark 合同备注 [ require false ]
     * @support  array $discountInfo 折扣 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\CreateYearContract\CreateYearContractDTO
     */
    public static function createYearContract () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createYearContract([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\CreateYearContract\CreateYearContractDTO"
        );
    }

    /**
     * 业务合同详情
     *
     * @param  int $id 合同id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\ContractDetail\ContractDetailDTO
     */
    public static function contractDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contractDetail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\ContractDetail\ContractDetailDTO"
        );
    }

    /**
     * 框架合同详情
     *
     * @param  int $id 合同id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\YearContractDetail\YearContractDetailDTO
     */
    public static function yearContractDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->yearContractDetail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\YearContractDetail\YearContractDetailDTO"
        );
    }

    /**
     * 修改合同
     *
     * @param  int $id 合同id [ require true ]
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [ require true ]
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  float $contract_money 合同金额 [ require false ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer [ require false ]
     * @support  string $contract_file_path 合同地址 [ require true ]
     * @support  string $contract_file_name 合同名称 [ require true ]
     * @support  string $remark 合同备注 [ require false ]
     * @support  array $discount_info 折扣 [ require false ]
     * @param  string $contract_type 合同类型 [ require true ]
     * @support  array $extend 扩展信息 [ require false ]
     * @support  string $start_at 框架生效时间 [ require false ]
     * @support  string $end_at 框架失效时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editContract (int $id, string $contract_type) {
        return self::getClass()->editContract([
            "id" => $id,
            "contract_type" => $contract_type,
        ]);
    }

    /**
     * 删除合同
     *
     * @param  int $id 合同id [ require true ]
     * @param  string $contract_type 合同类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteContract (int $id, string $contract_type) {
        return self::getClass()->deleteContract([
            "id" => $id,
            "contract_type" => $contract_type,
        ]);
    }

    /**
     * 上传盖印合同
     *
     * @param  int $contract_id 合同id [ require true ]
     * @param  string $final_file_path 盖印合同文件地址 [ require true ]
     * @param  string $final_file_name 盖印合同文件名 [ require true ]
     * @param  string $contract_type 合同类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadFinalFile (int $contract_id, string $contract_type, string $final_file_path, string $final_file_name) {
        return self::getClass()->uploadFinalFile([
            "contract_id" => $contract_id,
            "contract_type" => $contract_type,
            "final_file_path" => $final_file_path,
            "final_file_name" => $final_file_name,
        ]);
    }

    /**
     * 获取框架合同绑定订单列表
     *
     * @param  int $contract_id 合同id [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBindOrders (int $contract_id, int $page = 1, int $page_size = 20) {
        return self::getClass()->getBindOrders([
            "contract_id" => $contract_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 合同变更更新
     *
     * @support  string $oppositeContactPhone 客户手机号 [ require true ]
     * @support  string $oppositeContact 联系人姓名 [ require true ]
     * @support  string $industryType 行业 [ require true ]
     * @support  int $placingAreaCode 下单地区 [ require true ]
     * @support  string $contractCode 合同编号 [ require true ]
     * @support  string $isAfterPurchaseCustomer 顾客类型 [ require false ]
     * @support  bool $bothType 是否包含业务合同 [ require true ]
     * @support  string $contractTypeCode 合同类型 [ require true ]
     * @support  float $moneyInvolvedNumber 合同金额 [ require false ]
     * @support  string $contractStartDate 框架生效时间 [ require false ]
     * @support  string $contractEndDate 框架失效时间 [ require false ]
     * @support  float $signClassDiscount 折扣 [ require true ]
     * @support  float $otherProductDiscount 折扣 [ require true ]
     * @support  float $giftCardDiscount 折扣 [ require true ]
     * @support  float $orderDiscountCodeDiscount 折扣 [ require true ]
     * @support  string $token 身份验证 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\SyncUpdateContract\SyncUpdateContractDTO
     */
    public static function syncUpdateContract () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->syncUpdateContract([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\SyncUpdateContract\SyncUpdateContractDTO"
        );
    }

    /**
     * 合同新增
     *
     * @support  string $token 身份验证 [ require true ]
     * @support  int $enterpriseId 企业ID [ require true ]
     * @support  int $applyLoginName 创建人工号 [ require true ]
     * @support  string $oppositeContactPhone 客户手机号 [ require true ]
     * @support  array $auditorInfo 审核人信息 [ require true ]
     * @support  string $contractEndAuditDate 合同审核时间 [ require true ]
     * @support  string $contractCreateDate 合同创建时间 [ require true ]
     * @support  string $oppositeContact 联系人姓名 [ require true ]
     * @support  string $industryType 行业 [ require true ]
     * @support  int $placingAreaCode 下单地区 [ require true ]
     * @support  string $contractCode 合同编号 [ require true ]
     * @support  string $isAfterPurchaseCustomer 顾客类型 [ require false ]
     * @support  string $contractTypeCode 合同类型 [ require true ]
     * @support  bool $bothType 是否包含业务合同 [ require true ]
     * @support  float $moneyInvolvedNumber 合同金额 [ require false ]
     * @support  string $contractStartDate 框架生效时间 [ require false ]
     * @support  string $contractEndDate 框架失效时间 [ require false ]
     * @support  float $signClassDiscount 折扣 [ require false ]
     * @support  float $otherProductDiscount 折扣 [ require true ]
     * @support  float $giftCardDiscount 折扣 [ require true ]
     * @support  float $orderDiscountCodeDiscount 折扣 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\SyncCreateContract\SyncCreateContractDTO
     */
    public static function syncCreateContract () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->syncCreateContract([
                        ]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\SyncCreateContract\SyncCreateContractDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Contract');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Contract');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}