<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method calProductCardPriceByParams(array $params)
 * @method areaAllByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 计算产品卡价格
     *
     * @param  array $limit 模版limit [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calProductCardPrice (array $limit) {
        return self::getClass()->calProductCardPrice([
            "limit" => $limit,
        ]);
    }

    /**
     * 所有门店分区
     *
     * @param  string $module 价格区所属品牌 [ require true ]
     * @param  string $type 分区类型(价格区,服装区)(不传表示全部) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaAll (string $module, string $type = '') {
        return self::getClass()->areaAll([
            "module" => $module,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}