<?php
namespace Mainto\Bridge\Invokes\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUpyunSignByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method getStoreByParams(array $params)
 * @method getAllPriceAreaByParams(array $params)
 * @method getProductJxjyPriceByParams(array $params)
 * @method getBanStoreListByParams(array $params)
 * @method getShortUrlByParams(array $params)
 * @method sendMsgByParams(array $params)
 * @method getAllProvinceByParams(array $params)
 * @method getCityByParams(array $params)
 * @method getStoreListByParams(array $params)
 * @method getProductsByStoreByParams(array $params)
 * @method getProductsByStoreWithPackageByParams(array $params)
 * @method getSubPackageInfoByParams(array $params)
 * @method getProductDetailByParams(array $params)
 * @method getProductsBatchDetailByParams(array $params)
 * @method getEnumByParams(array $params)
 * @method getProductTreeByModulesByParams(array $params)
 * @method getAllProductByParams(array $params)
 * @method getAreaTreeByParams(array $params)
 * @method searchStaffByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method getStoreByCityByParams(array $params)
 * @method signByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取Host地址
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 获取所有门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStore () {
        return self::getClass()->getStore();
    }

    /**
     * 根据价格区id获取所有门店
     *
     * @support  string $module 品牌 [ require false ]
     * @support  array $ids 价格区ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllPriceArea () {
        return self::getClass()->getAllPriceArea([
        ]);
    }

    /**
     * 根据产品id获取加修价格
     *
     * @param  int $productId 产品id [ require true ]
     * @param  int $peopleCount 人数 [ require true ]
     * @param  array $storeLimit 门店限制信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductJxjyPrice (int $productId, int $peopleCount, array $storeLimit) {
        return self::getClass()->getProductJxjyPrice([
            "productId" => $productId,
            "peopleCount" => $peopleCount,
            "storeLimit" => $storeLimit,
        ]);
    }

    /**
     * 获取禁止售卖指定产品的门店列表
     *
     * @param  array $productIds 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBanStoreList (array $productIds) {
        return self::getClass()->getBanStoreList([
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取短链接
     *
     * @param  string $url 链接前缀 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShortUrl (string $url) {
        return self::getClass()->getShortUrl([
            "url" => $url,
        ]);
    }

    /**
     * 发送券码订单通知
     *
     * @param  string $template 模版id [ require true ]
     * @param  string $sendType 发送类型 [ require true ]
     * @param  array $sendArr 待发名单 [ require true ]
     * @param  array $sendContent 发送内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMsg (string $template, string $sendType, array $sendArr, array $sendContent) {
        return self::getClass()->sendMsg([
            "template" => $template,
            "sendType" => $sendType,
            "sendArr" => $sendArr,
            "sendContent" => $sendContent,
        ]);
    }

    /**
     * 获取所有省份
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProvince () {
        return self::getClass()->getAllProvince();
    }

    /**
     * 获取指定省份下的城市
     *
     * @param  int $province_id 上级省ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCity (int $province_id) {
        return self::getClass()->getCity([
            "province_id" => $province_id,
        ]);
    }

    /**
     * 获取门店列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreList () {
        return self::getClass()->getStoreList();
    }

    /**
     * 获取门店所有产品
     *
     * @support  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsByStore () {
        return self::getClass()->getProductsByStore([
        ]);
    }

    /**
     * 获取门店所有产品（套餐）
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $status 产品状态（默认上架） [ require false ]
     * @support  int $showLevel 产品层级 [ require false ]
     * @support  bool $cHidden 是否预约端隐藏 [ require false ]
     * @support  bool $cHiddenRetail 是否隐藏含有零售产品的套餐 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsByStoreWithPackage () {
        return self::getClass()->getProductsByStoreWithPackage([
        ]);
    }

    /**
     * 获取子套餐详情
     *
     * @support  int $packageId 套餐id [ require true ]
     * @support  int $subPackageId 子套餐id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSubPackageInfo () {
        return self::getClass()->getSubPackageInfo([
        ]);
    }

    /**
     * 获取产品详情
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDetail () {
        return self::getClass()->getProductDetail([
        ]);
    }

    /**
     * 批量获取多个产品详情
     *
     * @support  array $productIds 产品ID [ require true ]
     * @support  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsBatchDetail () {
        return self::getClass()->getProductsBatchDetail([
        ]);
    }

    /**
     * 获取enum
     *
     * @param  string $enum_name enum的名称 [ require true ]
     * @param  string $field_name field的名称 [ require true ]
     * @param  string $type 结果展示的方式tree/map/list [ require true ]
     * @param  string $prefix 枚举前缀 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getEnum (string $enum_name, string $field_name, string $type, string $prefix = '') {
        return self::getClass()->getEnum([
            "enum_name" => $enum_name,
            "field_name" => $field_name,
            "type" => $type,
            "prefix" => $prefix,
        ]);
    }

    /**
     * 根据MODULE获取类目/产品树
     *
     * @support  array $module 所属模块组 [ require false ]
     * @support  string $status 产品状态（默认上架） [ require false ]
     * @support  bool $c_hidden 是否包含预约端隐藏 [ require false ]
     * @support  int $show_level 起始类目等级 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductTreeByModules () {
        return self::getClass()->getProductTreeByModules([
        ]);
    }

    /**
     * 全部产品列表
     *
     * @support  int $categoryId 类目id [ require false ]
     * @support  string $module 产品所属模块 [ require false ]
     * @support  string $status 状态,会筛选子节点 [ require false ]
     * @support  bool $cHidden 预约端是否隐藏,会筛选子节点 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProduct () {
        return self::getClass()->getAllProduct([
        ]);
    }

    /**
     * 获取省市区三级
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAreaTree () {
        return self::getClass()->getAreaTree();
    }

    /**
     * 通过伙伴姓名或花名获得可能的工号
     *
     * @param  string $staff_name 伙伴姓名或花名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchStaff (string $staff_name) {
        return self::getClass()->searchStaff([
            "staff_name" => $staff_name,
        ]);
    }

    /**
     * 查询零售产品列表
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  array $skuIds skuIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductList () {
        return self::getClass()->getProductList([
        ]);
    }

    /**
     * 查询门店列表
     *
     * @support  array $storeType 限定的门店类型(&#039;blue&#039;, &#039;gold&#039;, &#039;activity&#039;) [ require false ]
     * @support  bool $includeDelete 包含删除的店铺 [ require false ]
     * @support  array $cityIds 城市的ID数组 [ require false ]
     * @support  string $type 获取类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreByCity () {
        return self::getClass()->getStoreByCity([
        ]);
    }

    /**
     * sign
     *
     * @param  string $upyun_key 需要签名的又拍云key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sign (string $upyun_key) {
        return self::getClass()->sign([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}