<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method addTeamMemberByParams(array $params)
 * @method deleteTeamMemberByParams(array $params)
 * @method performanceDetailByParams(array $params)
 * @method editShootContentByParams(array $params)
 * @method editMemberPerformanceByParams(array $params)
 * @method editStorePerformanceByParams(array $params)
 * @method confirmPerformanceByParams(array $params)
 */
class OutShoot {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取外摄订单详情
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 添加外拍队员
     *
     * @support  string $order_no 订单号 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @support  string $team_type 队员类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addTeamMember () {
        return self::getClass()->addTeamMember([
        ]);
    }

    /**
     * 删除外拍队员
     *
     * @support  string $order_no 订单号 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @support  string $team_type 队员类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteTeamMember () {
        return self::getClass()->deleteTeamMember([
        ]);
    }

    /**
     * 获取业绩填写详情
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function performanceDetail () {
        return self::getClass()->performanceDetail([
        ]);
    }

    /**
     * 编辑实际拍摄内容
     *
     * @support  string $order_no 订单号 [ require true ]
     * @support  array $final_purchase_info 实际拍摄内容 [ require true ]
     * @support  float $origin_price 订单原价 [ require true ]
     * @support  float $real_money 实际需要支付金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editShootContent () {
        return self::getClass()->editShootContent([
        ]);
    }

    /**
     * 编辑伙伴业绩盘点
     *
     * @support  string $order_no 订单号 [ require true ]
     * @support  array $member_performance 伙伴业绩 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editMemberPerformance () {
        return self::getClass()->editMemberPerformance([
        ]);
    }

    /**
     * 编辑门店业绩盘点
     *
     * @support  string $order_no 订单号 [ require true ]
     * @support  array $store_performance 门店业绩 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStorePerformance () {
        return self::getClass()->editStorePerformance([
        ]);
    }

    /**
     * 业绩确认
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmPerformance () {
        return self::getClass()->confirmPerformance([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\OutShoot');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\OutShoot');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}