<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createClueByParams(array $params)
 * @method createStoreByParams(array $params)
 * @method editClueByParams(array $params)
 * @method clueDetailByParams(array $params)
 * @method clueListByParams(array $params)
 * @method clueSimpleListByParams(array $params)
 * @method clueListByWxByParams(array $params)
 * @method clueAllByParams(array $params)
 * @method abandonClueByParams(array $params)
 * @method receiveClueByParams(array $params)
 * @method transferClueByParams(array $params)
 * @method distributionClueByParams(array $params)
 * @method checkTransferClueToEnterpriseByParams(array $params)
 * @method transferClueToEnterpriseByParams(array $params)
 */
class Clue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建线索
     *
     * @support  string $title 线索名称 [ require true ]
     * @support  string $from 线索来源 [ require false ]
     * @support  string $ip_address 线索来源ip [ require false ]
     * @support  string $wx_openid 线索来源wxopenid [ require false ]
     * @support  string $contact_name 联系人姓名 [ require true ]
     * @support  string $contact_gender 性别 [ require false ]
     * @support  array $contact_postcard 名片 [ require false ]
     * @support  string $contact_phone 联系人电话 [ require true ]
     * @support  int $photograph_area 城市id [ require true ]
     * @support  int $belong_staff 归属人工号 [ require true ]
     * @support  int $creator_id 创建人工号 [ require false ]
     * @support  string $remark 备注 [ require false ]
     * @support  array $extend 额外信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createClue () {
        return self::getClass()->createClue([
        ]);
    }

    /**
     * 创建线索(门店)
     *
     * @support  string $title 线索名称 [ require true ]
     * @support  string $from 线索来源 [ require false ]
     * @support  string $contactName 联系人姓名 [ require true ]
     * @support  string $contactGender 性别 [ require false ]
     * @support  array $contactPostcard 名片 [ require false ]
     * @support  string $contactPhone 联系人电话 [ require true ]
     * @support  int $photographArea 城市id [ require true ]
     * @support  int $belongStaff 归属人工号 [ require true ]
     * @support  int $creatorId 创建人工号 [ require false ]
     * @support  string $remark 备注 [ require false ]
     * @support  array $extend 额外信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createStore () {
        return self::getClass()->createStore([
        ]);
    }

    /**
     * 编辑线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @support  string $title 线索名称 [ require false ]
     * @support  string $from 线索来源 [ require false ]
     * @support  string $contact_name 联系人姓名 [ require true ]
     * @support  string $contact_gender 性别 [ require false ]
     * @support  array $contact_postcard 名片 [ require false ]
     * @support  string $contact_phone 联系人电话 [ require true ]
     * @support  int $photograph_area 城市id [ require true ]
     * @support  string $remark 备注 [ require false ]
     * @support  array $extend 额外信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editClue () {
        return self::getClass()->editClue([
        ]);
    }

    /**
     * 线索详情
     *
     * @support  int $clue_id 线索id [ require true ]
     * @support  string $event_type 消息事件类别 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function clueDetail () {
        return self::getClass()->clueDetail([
        ]);
    }

    /**
     * 线索列表
     *
     * @support  string $title 线索名称 [ require false ]
     * @support  string $contact_name 联系人名称 [ require false ]
     * @support  string $contact_phone 联系人电话 [ require false ]
     * @support  string $from 线索来源 [ require false ]
     * @support  bool $is_invalid 是否来自无效线索页签 [ require false ]
     * @support  int $photograph_area 城市id [ require false ]
     * @support  int $belong_staff 归属人 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  string $desc_sort_column 以什么字段倒序 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function clueList (int $page = 1, int $page_size = 10, string $desc_sort_column = 'log_at') {
        return self::getClass()->clueList([
            "page" => $page,
            "page_size" => $page_size,
            "desc_sort_column" => $desc_sort_column,
        ]);
    }

    /**
     * 线索列表（简易）
     *
     * @support  string $title 线索名称 [ require false ]
     * @support  string $from 线索来源 [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @support  bool $isEnterprise 是否转为客户1是0否 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function clueSimpleList () {
        return self::getClass()->clueSimpleList([
        ]);
    }

    /**
     * 门店端线索列表
     *
     * @support  string $from 线索来源 [ require false ]
     * @support  string $ipAddress 线索来源IP [ require false ]
     * @support  string $wxOpenid 线索来源WXopenid [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clueListByWx () {
        return self::getClass()->clueListByWx([
        ]);
    }

    /**
     * 线索导出
     *
     * @support  string $title 线索名称 [ require false ]
     * @support  string $contact_name 联系人名称 [ require false ]
     * @support  string $contact_phone 联系人电话 [ require false ]
     * @support  string $from 线索来源 [ require false ]
     * @support  bool $is_invalid 线索归类 [ require false ]
     * @support  int $photograph_area 城市id [ require false ]
     * @support  int $belong_staff 归属人 [ require false ]
     * @param  string $desc_sort_column 以什么字段倒序 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function clueAll (string $desc_sort_column = 'log_at') {
        return self::getClass()->clueAll([
            "desc_sort_column" => $desc_sort_column,
        ]);
    }

    /**
     * 放弃线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function abandonClue () {
        return self::getClass()->abandonClue([
        ]);
    }

    /**
     * 领取线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function receiveClue () {
        return self::getClass()->receiveClue([
        ]);
    }

    /**
     * 转移线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @support  int $receive_staff 转移的员工id [ require true ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function transferClue () {
        return self::getClass()->transferClue([
        ]);
    }

    /**
     * 分配线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @support  int $receive_staff 分配的员工id [ require true ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function distributionClue () {
        return self::getClass()->distributionClue([
        ]);
    }

    /**
     * 校验线索转企业
     *
     * @support  int $clueId 线索id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkTransferClueToEnterprise () {
        return self::getClass()->checkTransferClueToEnterprise([
        ]);
    }

    /**
     * 转移线索成企业
     *
     * @support  int $clue_id 线索id [ require true ]
     * @support  string $enterprise_name 企业名称 [ require false ]
     * @support  string $type 企业类型 [ require false ]
     * @support  string $from 来源 [ require false ]
     * @support  string $trade 行业 [ require false ]
     * @support  string $area 地区 [ require false ]
     * @support  string $social_credit_code 社会信用编码 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @support  string $key_no KeyNo [ require false ]
     * @support  string $start_date 成立日期 [ require false ]
     * @support  string $oper_name 法定代表人姓名 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $no 注册号 [ require false ]
     * @support  string $enterprise_level 企业等级 [ require false ]
     * @support  string $contacts 联系人 [ require false ]
     * @support  string $contact_number 联系电话 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function transferClueToEnterprise () {
        return self::getClass()->transferClueToEnterprise([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Clue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Clue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}