<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateCouponProductLimitByParams(array $params)
 * @method autoTransferClueToDefaultStaffByParams(array $params)
 * @method autoNoticeOutShootMembersByParams(array $params)
 * @method autoSendDingTalkNotFollowByParams(array $params)
 * @method setDataBigScreenByParams(array $params)
 * @method autoEvidenceByfluentNumsByParams(array $params)
 * @method autoCreateContractEveryHourByParams(array $params)
 * @method autoUpdateWorkStationRankCacheByParams(array $params)
 * @method autoOrderCardStatusToOrderExtendByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天1点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateCouponProductLimit () {
        return self::getClass()->updateCouponProductLimit();
    }

    /**
     * 每天1点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoTransferClueToDefaultStaff () {
        return self::getClass()->autoTransferClueToDefaultStaff();
    }

    /**
     * 每天下午5点通知第二天有外拍任务的伙伴
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoNoticeOutShootMembers () {
        return self::getClass()->autoNoticeOutShootMembers();
    }

    /**
     * 通知Bussiness七天未跟进客户
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function autoSendDingTalkNotFollow () {
        return self::getClass()->autoSendDingTalkNotFollow();
    }

    /**
     * 每天七点,七点五分，七点十分，七点十五执行，其余时间从缓存中获取,BUSINESS数据看板数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setDataBigScreen () {
        return self::getClass()->setDataBigScreen();
    }

    /**
     * 每一小时执行，解决招行转账缺少电子回单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoEvidenceByfluentNums () {
        return self::getClass()->autoEvidenceByfluentNums();
    }

    /**
     * 更新合同，每小时执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoCreateContractEveryHour () {
        return self::getClass()->autoCreateContractEveryHour();
    }

    /**
     * 更新工作台TOP10排名缓存，每日00:00:00执行
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoUpdateWorkStationRankCache () {
        return self::getClass()->autoUpdateWorkStationRankCache();
    }

    /**
     * 更新现有order表中的数据到orderExtend
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function autoOrderCardStatusToOrderExtend () {
        return self::getClass()->autoOrderCardStatusToOrderExtend();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}