<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method workStationIndexByParams(array $params)
 * @method polylineDataByParams(array $params)
 * @method getAllPaymentInfoByParams(array $params)
 * @method getCurrentMonthRankByParams(array $params)
 * @method getStaffRankInfoByParams(array $params)
 */
class WorkStation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 头部信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function workStationIndex () {
        return self::getClass()->workStationIndex();
    }

    /**
     * 首页折线数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function polylineData () {
        return self::getClass()->polylineData();
    }

    /**
     * 全量的金额状况
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllPaymentInfo () {
        return self::getClass()->getAllPaymentInfo();
    }

    /**
     * 缓冲中获取工作台排名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCurrentMonthRank () {
        return self::getClass()->getCurrentMonthRank();
    }

    /**
     * 缓冲中获取工作台登陆人排名信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffRankInfo () {
        return self::getClass()->getStaffRankInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\WorkStation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\WorkStation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}