<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method exportPreferentialListByParams(array $params)
 * @method getPreferentialUseInfoByParams(array $params)
 * @method exportPreferentialUseInfoByParams(array $params)
 * @method allGiftCardCoverByParams(array $params)
 * @method batchAbolishByParams(array $params)
 * @method getGiftCardCoverByStoreIdByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 导出券码列表
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportPreferentialList (int $order_id) {
        return self::getClass()->exportPreferentialList([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取券码使用详情
     *
     * @param  array $search_info 券码创建记录id数组,[[&#039;create_log_id&#039;=&gt;1,&#039;type&#039;=&gt;&#039;coupon&#039;,&#039;amount&#039; =&gt;1]] [ require false ]
     * @param  int $order_id 订单id [ require true ]
     * @param  string $white_list 白名单内容，手机号/邮箱/券码 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferentialUseInfo (int $order_id, array $search_info = [], string $white_list = '', int $page = 1, int $page_size = 20) {
        return self::getClass()->getPreferentialUseInfo([
            "order_id" => $order_id,
            "search_info" => $search_info,
            "white_list" => $white_list,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 导出券码使用详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportPreferentialUseInfo (int $order_id) {
        return self::getClass()->exportPreferentialUseInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取礼品卡卡面列表(全部)
     *
     * @support  int $topic_id 主题ids [ require false ]
     * @support  string $title 卡面标题 [ require false ]
     * @support  bool $has_topic_info 是否包含主题信息 [ require false ]
     * @support  bool $is_on_sale 是否在售 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allGiftCardCover () {
        return self::getClass()->allGiftCardCover([
        ]);
    }

    /**
     * 批量券码作废
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  array $codes 券码组(带类型) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchAbolish () {
        return self::getClass()->batchAbolish([
        ]);
    }

    /**
     * 获取门店1030店铺实体礼品卡面信息
     *
     * @support  int $storeId 门店ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiftCardCoverByStoreId () {
        return self::getClass()->getGiftCardCoverByStoreId([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}