<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Role {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取角色列表
     *
     * @param  string $title 搜索角色名字 [ require false ]
     * @param  int $page 分页 [ require false ]
     * @param  int $page_size 每页大小 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (string $title = '', int $page = 1, int $page_size = 15) {
        return self::getClass()->list([
            "title" => $title,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取角色列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 创建角色
     *
     * @param  string $title 角色名 [ require true ]
     * @param  array $permission_ids 权限数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $title, array $permission_ids) {
        return self::getClass()->create([
            "title" => $title,
            "permission_ids" => $permission_ids,
        ]);
    }

    /**
     * 角色信息
     *
     * @param  int $role_id 角色id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $role_id) {
        return self::getClass()->detail([
            "role_id" => $role_id,
        ]);
    }

    /**
     * 设置角色权限
     *
     * @param  int $role_id 角色id [ require true ]
     * @param  array $permission_ids 权限数组 [ require true ]
     * @param  string $title 标题 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $role_id, array $permission_ids, string $title = '') {
        return self::getClass()->update([
            "role_id" => $role_id,
            "permission_ids" => $permission_ids,
            "title" => $title,
        ]);
    }

    /**
     * 删除角色
     *
     * @param  int $role_id 角色id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $role_id) {
        return self::getClass()->delete([
            "role_id" => $role_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Role');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Role');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}