<?php
namespace Mainto\Bridge\Invokes\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendInteractiveCardByParams(array $params)
 * @method sendDingTalkAccountReceiveByParams(array $params)
 * @method getEightCityIncomeAllByParams(array $params)
 * @method getIncomeAllByParams(array $params)
 * @method getRepurchaseRateAllByParams(array $params)
 * @method getBdPerforRankAllByParams(array $params)
 * @method getTradeRateAllByParams(array $params)
 * @method getGmvIncomeAllByParams(array $params)
 * @method getBusinessRateAllByParams(array $params)
 * @method getUseRateAllByParams(array $params)
 * @method getCityIncomeRankAllByParams(array $params)
 * @method dealInvocieFailedByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 七天未跟踪客户给归属者员工发钉钉消息提示跟进
     *
     * @param  array $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendInteractiveCard (array $content) {
        return self::getClass()->sendInteractiveCard([
            "content" => $content,
        ]);
    }

    /**
     * 资金到账给归属人员工发送信息提示
     *
     * @param  array $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDingTalkAccountReceive (array $content) {
        return self::getClass()->sendDingTalkAccountReceive([
            "content" => $content,
        ]);
    }

    /**
     * 获得缓存 8个城市合同、订单、GMV汇总
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getEightCityIncomeAll () {
        return self::getClass()->getEightCityIncomeAll();
    }

    /**
     * 获得缓存 合同数、订单数
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getIncomeAll () {
        return self::getClass()->getIncomeAll();
    }

    /**
     * 获得缓存 复购率、复购数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRepurchaseRateAll () {
        return self::getClass()->getRepurchaseRateAll();
    }

    /**
     * 获得缓存 BD业绩排名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getBdPerforRankAll () {
        return self::getClass()->getBdPerforRankAll();
    }

    /**
     * 获得缓存 行业占比
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTradeRateAll () {
        return self::getClass()->getTradeRateAll();
    }

    /**
     * 获得缓存 当前月GMV金额
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getGmvIncomeAll () {
        return self::getClass()->getGmvIncomeAll();
    }

    /**
     * 获得缓存 业务占比情况
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getBusinessRateAll () {
        return self::getClass()->getBusinessRateAll();
    }

    /**
     * 获得缓存 BUSINESS业务率
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUseRateAll () {
        return self::getClass()->getUseRateAll();
    }

    /**
     * 获得缓存 城市业绩排名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCityIncomeRankAll () {
        return self::getClass()->getCityIncomeRankAll();
    }

    /**
     * 开票失败处理监听
     *
     * @support  int $invoiceId 发票ID require false
     * @support  string $status 状态 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function dealInvocieFailed () {
        return self::getClass()->dealInvocieFailed();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}