<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotoByParams(array $params)
 * @method getShootOrderPhotoByParams(array $params)
 * @method getOutShootPhotoByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取券码订单拍摄照片
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $start 开始时间 require false
     * @support  string $end 结束时间 require false
     * @support  int $page 页数 require false
     * @support  int $page_size 每页条数 require false
     * @support  int $order_count 每页订单数 require false
     * @support  array $codes 券码集合 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhoto () {
        return self::getClass()->getPhoto();
    }

    /**
     * 获取拍摄订单拍摄照片
     *
     * @param  int $order_id 团购订单id [ require true ]
     * @param  string $start 开始时间 [ require true ]
     * @param  string $end 结束时间 [ require true ]
     * @param  int $page 页数 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @param  int $order_count 每页订单数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShootOrderPhoto (int $order_id, string $start, string $end, int $page = 1, int $page_size = 20, int $order_count = 50) {
        return self::getClass()->getShootOrderPhoto([
            "order_id" => $order_id,
            "start" => $start,
            "end" => $end,
            "page" => $page,
            "page_size" => $page_size,
            "order_count" => $order_count,
        ]);
    }

    /**
     * 获取外拍订单拍摄照片
     *
     * @support  array $order_id_group 门店拍摄订单ids [ require true ]
     * @support  string $start 开始时间 require false
     * @support  string $end 结束时间 require false
     * @support  int $page 页数 require false
     * @support  int $page_size 每页条数 require false
     * @support  int $order_count 每页订单数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOutShootPhoto () {
        return self::getClass()->getOutShootPhoto();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}