<?php
namespace Mainto\Bridge\Invokes\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendInteractiveCardByParams(array $params)
 * @method sendDingTalkAccountReceiveByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 七天未跟踪客户给归属者员工发钉钉消息提示跟进
     *
     * @param  array $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendInteractiveCard (array $content) {
        return self::getClass()->sendInteractiveCard([
            "content" => $content,
        ]);
    }

    /**
     * 资金到账给归属人员工发送信息提示
     *
     * @param  array $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDingTalkAccountReceive (array $content) {
        return self::getClass()->sendDingTalkAccountReceive([
            "content" => $content,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}